/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import moe.plushie.armourers_workshop.compatibility.core.AbstractRegistryManager;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.LivingEntity.EquipmentItemProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.Fix1621;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.MathHelper;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.selector.EffectSelector;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.selector.ItemSelector;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.selector.LivingEntitySelector;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.ContextSelectorImpl;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.EffectSelectorImpl;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.EntitySelectorImpl;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.ItemSelectorImpl;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenEquipmentSlot;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class LivingEntitySelectorImpl<T extends LivingEntity>
extends EntitySelectorImpl<T>
implements LivingEntitySelector {
    private static final Map<String, Optional<OpenEquipmentSlot>> NAMED_SLOTS = new ConcurrentHashMap<String, Optional<OpenEquipmentSlot>>();
    private static final Map<String, OpenEquipmentSlot> FIXED_SLOTS = Collections.immutableMap(it -> {
        it.put((Object)"chest", (Object)OpenEquipmentSlot.CHEST);
        it.put((Object)"feet", (Object)OpenEquipmentSlot.FEET);
        it.put((Object)"head", (Object)OpenEquipmentSlot.HEAD);
        it.put((Object)"legs", (Object)OpenEquipmentSlot.LEGS);
        it.put((Object)"mainhand", (Object)OpenEquipmentSlot.MAINHAND);
        it.put((Object)"offhand", (Object)OpenEquipmentSlot.OFFHAND);
        it.put((Object)"body", (Object)OpenEquipmentSlot.BODY);
    });
    private final ItemSelectorImpl itemSelector = new ItemSelectorImpl();
    private final EffectSelectorImpl effectSelector = new EffectSelectorImpl();

    @Override
    public LivingEntitySelectorImpl<T> apply(T entity, ContextSelectorImpl context) {
        super.apply(entity, context);
        return this;
    }

    @Override
    public double bodyYaw() {
        return MathHelper.lerp(this.partialTick(), ((LivingEntity)this.entity).field_70127_C, PropertyProvider.getXRot(this.entity));
    }

    @Override
    public double bodyPitch() {
        return MathHelper.wrapDegrees(MathHelper.lerp(this.partialTick(), ((LivingEntity)this.entity).field_70126_B, PropertyProvider.getYRot(this.entity)));
    }

    @Override
    public double health() {
        return ((LivingEntity)this.entity).func_110143_aJ();
    }

    @Override
    public double maxHealth() {
        return ((LivingEntity)this.entity).func_110138_aP();
    }

    @Override
    public double armorValue() {
        return ((LivingEntity)this.entity).func_70658_aO();
    }

    @Override
    public double hurtTime() {
        return ((LivingEntity)this.entity).field_70737_aN;
    }

    @Override
    public boolean isDeadOrDying() {
        return ((LivingEntity)this.entity).func_233643_dh_();
    }

    @Override
    public boolean isEating() {
        return ((LivingEntity)this.entity).func_184607_cu().func_77975_n() == UseAction.EAT;
    }

    @Override
    public boolean isSleeping() {
        return ((LivingEntity)this.entity).func_70608_bn();
    }

    @Override
    public boolean isUsingItem() {
        return ((LivingEntity)this.entity).func_184587_cr();
    }

    @Override
    public boolean isAutoSpinAttack() {
        return ((LivingEntity)this.entity).func_204805_cN();
    }

    @Override
    public boolean isOnClimbable() {
        return ((LivingEntity)this.entity).func_70617_f_();
    }

    @Override
    public double usingItemDuration() {
        return (double)((LivingEntity)this.entity).func_184612_cw() / 20.0;
    }

    @Override
    public double usingItemMaxDuration() {
        ItemStack item = ((LivingEntity)this.entity).func_184607_cu();
        if (!item.func_190926_b()) {
            return Fix1621.getUseDuration(item, (LivingEntity)this.entity) / 20.0;
        }
        return 0.0;
    }

    @Override
    public double usingItemRemainingDuration() {
        return (double)((LivingEntity)this.entity).func_184605_cv() / 20.0;
    }

    @Override
    public int arrowCount() {
        return ((LivingEntity)this.entity).func_85035_bI();
    }

    @Override
    public int stingerCount() {
        return ((LivingEntity)this.entity).func_226297_df_();
    }

    @Override
    public double attributeValueByName(String name) {
        return AbstractRegistryManager.getAttribute((LivingEntity)this.entity, name);
    }

    @Override
    @Nullable
    public EffectSelector effectByName(String name) {
        EffectInstance effect = AbstractRegistryManager.getEffect((LivingEntity)this.entity, name);
        if (effect != null) {
            return this.effectSelector.apply(effect);
        }
        return null;
    }

    @Override
    @Nullable
    public ItemSelector equippedItemBySlot(String name) {
        Optional slot = NAMED_SLOTS.computeIfAbsent(name, LivingEntitySelectorImpl::findSlot);
        ItemStack itemStack = slot.map(it -> EquipmentItemProvider.getItemBySlot((LivingEntity)this.entity, it)).orElse(ItemStack.field_190927_a);
        if (!itemStack.func_190926_b()) {
            return this.itemSelector.apply(itemStack);
        }
        return null;
    }

    @Override
    public int equipmentCount() {
        int count = 0;
        for (OpenEquipmentSlot slot : OpenEquipmentSlot.values()) {
            ItemStack stack;
            if (slot == OpenEquipmentSlot.MAINHAND || slot == OpenEquipmentSlot.OFFHAND || (stack = EquipmentItemProvider.getItemBySlot((LivingEntity)this.entity, slot)).func_190926_b()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int lastClimbableFacing() {
        World level = PropertyProvider.getLevel(this.entity);
        if (level == null) {
            return 0;
        }
        Optional climbablePos = ((LivingEntity)this.entity).func_233644_dn_();
        if (!climbablePos.isPresent()) {
            return 0;
        }
        BlockState blockState = level.func_180495_p((BlockPos)climbablePos.get());
        Optional facing = blockState.func_235903_d_((Property)HorizontalBlock.field_185512_D);
        return facing.map(Direction::func_176736_b).orElse(0);
    }

    private static Optional<OpenEquipmentSlot> findSlot(String name) {
        return Optional.ofNullable(FIXED_SLOTS.get(name.toLowerCase()));
    }
}

