/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.document;

import java.util.LinkedHashMap;
import java.util.Stack;
import moe.plushie.armourers_workshop.core.network.UpdateSkinDocumentPacket;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentListener;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentType;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;

public class SkinDocumentSynchronizer
implements SkinDocumentListener {
    protected boolean isApplying = false;
    protected boolean isCapturing = false;
    protected boolean isClient = false;
    protected CompoundNBT capturedPropertiesValues;
    protected CompoundNBT capturedSettingValues;
    protected final LinkedHashMap<String, CompoundNBT> capturedNodeValues = new LinkedHashMap();
    protected final Stack<Boolean> capturedStates = new Stack();
    protected final TileEntity blockEntity;

    public SkinDocumentSynchronizer(TileEntity blockEntity, boolean isClient) {
        this.blockEntity = blockEntity;
        this.isClient = isClient;
    }

    @Override
    public void documentDidChangeType(SkinDocumentType type) {
        this.post(new UpdateSkinDocumentPacket.ChangeTypeAction(type));
    }

    @Override
    public void documentDidChangeSettings(CompoundNBT tag) {
        if (this.isCapturing) {
            if (this.capturedSettingValues != null) {
                this.capturedSettingValues.func_197643_a(tag);
            } else {
                this.capturedSettingValues = tag;
            }
            return;
        }
        this.post(new UpdateSkinDocumentPacket.UpdateSettingsAction(tag));
    }

    @Override
    public void documentDidChangeProperties(CompoundNBT tag) {
        if (this.isCapturing) {
            if (this.capturedPropertiesValues != null) {
                this.capturedPropertiesValues.func_197643_a(tag);
            } else {
                this.capturedPropertiesValues = tag;
            }
            return;
        }
        this.post(new UpdateSkinDocumentPacket.UpdatePropertiesAction(tag));
    }

    @Override
    public void documentDidInsertNode(SkinDocumentNode node, SkinDocumentNode target, int index) {
        TagSerializer builder = new TagSerializer();
        target.serialize(builder);
        this.post(new UpdateSkinDocumentPacket.InsertNodeAction(node.id(), index, builder.tag()));
    }

    @Override
    public void documentDidUpdateNode(SkinDocumentNode node, CompoundNBT tag) {
        if (this.isCapturing) {
            this.capturedNodeValues.computeIfAbsent(node.id(), it -> tag).func_197643_a(tag);
            return;
        }
        this.post(new UpdateSkinDocumentPacket.UpdateNodeAction(node.id(), tag));
    }

    @Override
    public void documentDidRemoveNode(SkinDocumentNode node) {
        this.post(new UpdateSkinDocumentPacket.RemoveNodeAction(node.id()));
    }

    @Override
    public void documentDidMoveNode(SkinDocumentNode node, SkinDocumentNode target, int index) {
        this.post(new UpdateSkinDocumentPacket.MoveNodeAction(node.id(), target.id(), index));
    }

    @Override
    public void documentWillBeginEditing() {
        this.isApplying = true;
    }

    @Override
    public void documentDidEndEditing() {
        this.isApplying = false;
    }

    public void beginCapture() {
        this.capturedStates.push(this.isCapturing);
        this.isCapturing = true;
    }

    public void endCapture() {
        this.isCapturing = this.capturedStates.pop();
        if (this.isCapturing) {
            return;
        }
        if (this.capturedPropertiesValues != null) {
            this.documentDidChangeProperties(this.capturedPropertiesValues);
            this.capturedPropertiesValues = null;
        }
        if (this.capturedSettingValues != null) {
            this.documentDidChangeSettings(this.capturedSettingValues);
            this.capturedSettingValues = null;
        }
        this.capturedNodeValues.forEach((id, tag) -> this.post(new UpdateSkinDocumentPacket.UpdateNodeAction((String)id, (CompoundNBT)tag)));
        this.capturedNodeValues.clear();
    }

    protected void post(UpdateSkinDocumentPacket.Action action) {
        if (this.isApplying) {
            return;
        }
        if (this.isClient) {
            NetworkManager.sendToServer(new UpdateSkinDocumentPacket(this.blockEntity, action));
        } else {
            NetworkManager.sendToTrackingBlock(new UpdateSkinDocumentPacket(this.blockEntity, action), this.blockEntity);
        }
    }
}

