/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.PackObject;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.PackResourceSet;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockComponent;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockCurve;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockEvent;
import moe.plushie.armourers_workshop.core.skin.serializer.importer.bedrock.BedrockParticle;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOConsumer;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IODataObject;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOFunction;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenExpression;
import org.jetbrains.annotations.Nullable;

public class BedrockParticleReader {
    protected final String name;
    protected final PackResourceSet resourceSet;

    public BedrockParticleReader(File file) throws IOException {
        this.name = file.getName();
        this.resourceSet = new PackResourceSet(file);
    }

    public BedrockParticle readPack() throws IOException {
        PackObject modelObject = PackObject.from(this.resourceSet.firstResource());
        if (modelObject != null) {
            return this.parseParticleObject(modelObject);
        }
        throw new IOException("error.bb.loadParticle.noModel");
    }

    protected BedrockParticle parseParticleObject(PackObject object) throws IOException {
        BedrockParticle.Builder builder = new BedrockParticle.Builder();
        object.at("format_version", it -> builder.format(it.stringValue()));
        object.at("particle_effect", it -> {
            it.at("description.identifier", it2 -> builder.name(it2.stringValue()));
            it.at("description.basic_render_parameters", it1 -> {
                it1.at("material", it2 -> builder.material(it2.stringValue()));
                it1.at("texture", it2 -> builder.texture(it2.stringValue()));
            });
            it.each("curves", (key, value) -> builder.addCurve((String)key, this.parseCurveObject((PackObject)value)));
            it.each("components", (key, value) -> builder.addComponent((String)key, this.parseComponentObject((String)key, (PackObject)value)));
            it.each("events", (key, value) -> builder.addEvent((String)key, this.parseEventObject((PackObject)value)));
        });
        return builder.build();
    }

    protected BedrockCurve parseCurveObject(PackObject object) throws IOException {
        BedrockCurve.Builder builder = new BedrockCurve.Builder();
        object.at("type", it -> builder.type(it.stringValue()));
        object.at("input", it -> builder.input(it.expression()));
        object.at("horizontal_range", it -> builder.range(it.expression()));
        object.at("nodes", it -> {
            ArrayList<Float> parameters = new ArrayList<Float>();
            switch (it.type()) {
                case ARRAY: {
                    it.allValues().forEach(it2 -> parameters.add(Float.valueOf(it2.floatValue())));
                    break;
                }
                case DICTIONARY: {
                    it.entrySet().forEach(it2 -> {
                        parameters.add(Float.valueOf(Float.parseFloat((String)it2.getKey())));
                        parameters.add(Float.valueOf(((IODataObject)it2.getValue()).get("value").floatValue()));
                        parameters.add(Float.valueOf(((IODataObject)it2.getValue()).get("slope").floatValue()));
                    });
                }
            }
            builder.parameters(parameters);
        });
        return builder.build();
    }

    protected BedrockComponent parseComponentObject(String name, PackObject object) throws IOException {
        IOFunction<PackObject, BedrockComponent> iOFunction;
        switch (name) {
            case "minecraft:emitter_initialization": {
                iOFunction = this.parse(BedrockComponent.EmitterInitialization.Builder::new, builder -> {
                    object.at("creation_expression", it -> builder.creation(it.expression()));
                    object.at("per_update_expression", it -> builder.update(it.expression()));
                });
                break;
            }
            case "minecraft:emitter_local_space": {
                iOFunction = this.parse(BedrockComponent.EmitterLocalSpace.Builder::new, builder -> {
                    object.at("position", it -> builder.position(it.boolValue()));
                    object.at("rotation", it -> builder.rotation(it.boolValue()));
                    object.at("velocity", it -> builder.velocity(it.boolValue()));
                });
                break;
            }
            case "minecraft:emitter_rate_steady": {
                iOFunction = this.parse(BedrockComponent.EmitterSteadyRate.Builder::new, builder -> {
                    object.at("spawn_rate", it -> builder.spawnRate(it.expression()));
                    object.at("max_particles", it -> builder.maxParticles(it.expression()));
                });
                break;
            }
            case "minecraft:emitter_rate_instant": {
                iOFunction = this.parse(BedrockComponent.EmitterInstantRate.Builder::new, builder -> object.at("num_particles", it -> builder.particles(it.expression())));
                break;
            }
            case "minecraft:emitter_rate_manual": {
                iOFunction = this.parse(BedrockComponent.EmitterManualRate.Builder::new, builder -> object.at("max_particles", it -> builder.maxParticles(it.expression())));
                break;
            }
            case "minecraft:emitter_lifetime_events": {
                iOFunction = this.parse(BedrockComponent.EmitterEventLifetime.Builder::new, builder -> {
                    object.at("creation_event", it -> builder.creation(it.collect(IODataObject::stringValue)));
                    object.at("expiration_event", it -> builder.expiration(it.collect(IODataObject::stringValue)));
                    object.each("timeline", (key, value) -> builder.timeline((String)key, (List<String>)value.collect(IODataObject::stringValue)));
                    object.each("travel_distance_events", (key, value) -> builder.travelDistance((String)key, (List<String>)value.collect(IODataObject::stringValue)));
                    object.each("looping_travel_distance_events", it -> builder.travelDistanceLoop(it.get("distance").floatValue(), it.get("effects").collect(IODataObject::stringValue)));
                });
                break;
            }
            case "minecraft:emitter_lifetime_looping": {
                iOFunction = this.parse(BedrockComponent.EmitterLoopingLifetime.Builder::new, builder -> {
                    object.at("active_time", it -> builder.activeTime(it.expression()));
                    object.at("sleep_time", it -> builder.sleepTime(it.expression()));
                });
                break;
            }
            case "minecraft:emitter_lifetime_once": {
                iOFunction = this.parse(BedrockComponent.EmitterOnceLifetime.Builder::new, builder -> object.at("active_time", it -> builder.activeTime(it.expression())));
                break;
            }
            case "minecraft:emitter_lifetime_expression": {
                iOFunction = this.parse(BedrockComponent.EmitterExpressionLifetime.Builder::new, builder -> {
                    object.at("activation_expression", it -> builder.activation(it.expression()));
                    object.at("expiration_expression", it -> builder.expiration(it.expression()));
                });
                break;
            }
            case "minecraft:emitter_shape_point": {
                iOFunction = this.parse(BedrockComponent.EmitterPointShape.Builder::new, builder -> object.at("offset", it -> {
                    builder.offsetX(it.at(0).expression());
                    builder.offsetY(it.at(1).expression());
                    builder.offsetZ(it.at(2).expression());
                }));
                break;
            }
            case "minecraft:emitter_shape_entity_aabb": {
                iOFunction = this.parse(BedrockComponent.EmitterEntityShape.Builder::new, builder -> {
                    object.at("direction", it -> builder.direction(this.parseShapeDirection((PackObject)it)));
                    object.at("surface_only", it -> builder.surfaceOnly(it.boolValue()));
                });
                break;
            }
            case "minecraft:emitter_shape_sphere": {
                iOFunction = this.parse(BedrockComponent.EmitterSphereShape.Builder::new, builder -> {
                    object.at("radius", it -> builder.radius(it.expression()));
                    object.at("offset", it -> {
                        builder.offsetX(it.at(0).expression());
                        builder.offsetY(it.at(1).expression());
                        builder.offsetZ(it.at(2).expression());
                    });
                    object.at("direction", it -> builder.direction(this.parseShapeDirection((PackObject)it)));
                    object.at("surface_only", it -> builder.surfaceOnly(it.boolValue()));
                });
                break;
            }
            case "minecraft:emitter_shape_box": {
                iOFunction = this.parse(BedrockComponent.EmitterBoxShape.Builder::new, builder -> {
                    object.at("half_dimensions", it -> {
                        builder.width(it.at(0).expression());
                        builder.height(it.at(1).expression());
                        builder.depth(it.at(2).expression());
                    });
                    object.at("offset", it -> {
                        builder.offsetX(it.at(0).expression());
                        builder.offsetY(it.at(1).expression());
                        builder.offsetZ(it.at(2).expression());
                    });
                    object.at("direction", it -> builder.direction(this.parseShapeDirection((PackObject)it)));
                    object.at("surface_only", it -> builder.surfaceOnly(it.boolValue()));
                });
                break;
            }
            case "minecraft:emitter_shape_disc": {
                iOFunction = this.parse(BedrockComponent.EmitterDiscShape.Builder::new, builder -> {
                    object.at("plane_normal", it -> {
                        builder.planeNormalX(it.at(0).expression());
                        builder.planeNormalY(it.at(1).expression());
                        builder.planeNormalZ(it.at(2).expression());
                    });
                    object.at("offset", it -> {
                        builder.offsetX(it.at(0).expression());
                        builder.offsetY(it.at(1).expression());
                        builder.offsetZ(it.at(2).expression());
                    });
                    object.at("direction", it -> builder.direction(this.parseShapeDirection((PackObject)it)));
                    object.at("radius", it -> builder.radius(it.expression()));
                    object.at("surface_only", it -> builder.surfaceOnly(it.boolValue()));
                });
                break;
            }
            case "minecraft:particle_initialization": {
                iOFunction = this.parse(BedrockComponent.ParticleInitialization.Builder::new, builder -> {
                    object.at("per_update_expression", it -> builder.update(it.expression()));
                    object.at("per_render_expression", it -> builder.render(it.expression()));
                });
                break;
            }
            case "minecraft:particle_initial_speed": {
                iOFunction = this.parse(BedrockComponent.ParticleInitialSpeed.Builder::new, builder -> builder.speed(object.expression()));
                break;
            }
            case "minecraft:particle_initial_spin": {
                iOFunction = this.parse(BedrockComponent.ParticleInitialSpin.Builder::new, builder -> {
                    object.at("rotation", it -> builder.rotation(it.expression()));
                    object.at("rotation_rate", it -> builder.rotationRate(it.expression()));
                });
                break;
            }
            case "minecraft:particle_lifetime_events": {
                iOFunction = this.parse(BedrockComponent.ParticleEventLifetime.Builder::new, builder -> {
                    object.at("creation_event", it -> builder.creation(it.collect(IODataObject::stringValue)));
                    object.at("expiration_event", it -> builder.expiration(it.collect(IODataObject::stringValue)));
                    object.each("timeline", (key, value) -> builder.timeline((String)key, (List<String>)value.collect(IODataObject::stringValue)));
                });
                break;
            }
            case "minecraft:particle_lifetime_expression": {
                iOFunction = this.parse(BedrockComponent.ParticleExpressLifetime.Builder::new, builder -> {
                    object.at("max_lifetime", it -> builder.maxAge(it.expression()));
                    object.at("expiration_expression", it -> builder.expiration(it.expression()));
                });
                break;
            }
            case "minecraft:particle_kill_plane": {
                iOFunction = this.parse(BedrockComponent.ParticleKillInPlaneLifetime.Builder::new, builder -> object.allValues().forEach(it -> builder.add(it.floatValue())));
                break;
            }
            case "minecraft:particle_expire_if_in_blocks": {
                iOFunction = this.parse(BedrockComponent.ParticleKillInBlocksLifetime.Builder::new, builder -> object.allValues().forEach(it -> builder.add(it.stringValue())));
                break;
            }
            case "minecraft:particle_expire_if_not_in_blocks": {
                iOFunction = this.parse(BedrockComponent.ParticleOnlyInBlocksLifetime.Builder::new, builder -> object.allValues().forEach(it -> builder.add(it.stringValue())));
                break;
            }
            case "minecraft:particle_motion_collision": {
                iOFunction = this.parse(BedrockComponent.ParticleCollisionMotion.Builder::new, builder -> {
                    object.at("enabled", it -> builder.enabled(it.expression()));
                    object.at("collision_drag", it -> builder.collisionDrag(it.floatValue()));
                    object.at("collision_radius", it -> builder.collisionRadius(it.floatValue()));
                    object.at("coefficient_of_restitution", it -> builder.coefficientOfRestitution(it.floatValue()));
                    object.at("expire_on_contact", it -> builder.expireOnContact(it.boolValue()));
                    object.each("events", it -> builder.event(it.get("min_speed").floatValue(), it.get("event").stringValue()));
                });
                break;
            }
            case "minecraft:particle_motion_dynamic": {
                iOFunction = this.parse(BedrockComponent.ParticleDynamicMotion.Builder::new, builder -> {
                    object.at("linear_acceleration", it -> {
                        builder.linearAccelerationX(it.at(0).expression());
                        builder.linearAccelerationY(it.at(1).expression());
                        builder.linearAccelerationZ(it.at(2).expression());
                    });
                    object.at("linear_drag_coefficient", it -> builder.linearDragCoefficient(it.expression()));
                    object.at("rotation_acceleration", it -> builder.rotationAcceleration(it.expression()));
                    object.at("rotation_drag_coefficient", it -> builder.rotationDragCoefficient(it.expression()));
                });
                break;
            }
            case "minecraft:particle_motion_parametric": {
                iOFunction = this.parse(BedrockComponent.ParticleParametricMotion.Builder::new, builder -> {
                    object.at("relative_position", it -> {
                        builder.relativePositionX(it.at(0).expression());
                        builder.relativePositionY(it.at(1).expression());
                        builder.relativePositionZ(it.at(2).expression());
                    });
                    object.at("direction", it -> {
                        builder.directionX(it.at(0).expression());
                        builder.directionY(it.at(1).expression());
                        builder.directionZ(it.at(2).expression());
                    });
                });
                break;
            }
            case "minecraft:particle_appearance_billboard": {
                iOFunction = this.parse(BedrockComponent.ParticleBillboardAppearance.Builder::new, builder -> {
                    object.at("size", it -> {
                        builder.width(it.at(0).expression());
                        builder.height(it.at(1).expression());
                    });
                    object.at("facing_camera_mode", it -> builder.facingCameraMode(it.stringValue()));
                    object.at("direction", it -> {});
                    object.at("uv", it -> {
                        it.at("texture_width", it2 -> builder.textureWidth(it2.intValue()));
                        it.at("texture_height", it2 -> builder.textureHeight(it2.intValue()));
                        it.at("uv", it2 -> {
                            builder.textureCoordsX(it2.at(0).expression());
                            builder.textureCoordsY(it2.at(1).expression());
                        });
                        it.at("uv_size", it2 -> {
                            builder.textureCoordsWidth(it2.at(0).expression());
                            builder.textureCoordsHeight(it2.at(1).expression());
                        });
                        it.at("flipbook", it1 -> builder.useAnimation(true));
                        it.at("flipbook", it1 -> {
                            it1.at("base_UV", it2 -> {
                                builder.textureCoordsX(it2.at(0).expression());
                                builder.textureCoordsY(it2.at(1).expression());
                            });
                            it1.at("size_UV", it2 -> {
                                builder.textureCoordsWidth(it2.at(0).expression());
                                builder.textureCoordsHeight(it2.at(1).expression());
                            });
                            it1.at("step_UV", it2 -> {
                                builder.stepX(it2.at(0).expression());
                                builder.stepY(it2.at(1).expression());
                            });
                            it1.at("frames_per_second", it2 -> builder.fps(it2.intValue()));
                            it1.at("max_frame", it2 -> builder.maxFrame(it2.expression()));
                            it1.at("stretch_to_lifetime", it2 -> builder.stretchToLifetime(it2.boolValue()));
                            it1.at("loop", it2 -> builder.loop(it2.boolValue()));
                        });
                    });
                });
                break;
            }
            case "minecraft:particle_appearance_tinting": {
                iOFunction = this.parse(BedrockComponent.ParticleTintingAppearance.Builder::new, builder -> object.at("color", it -> {
                    switch (it.type()) {
                        case ARRAY: {
                            builder.addColor(it.at(0).expression());
                            builder.addColor(it.at(1).expression());
                            builder.addColor(it.at(2).expression());
                            builder.addColor(it.at(3).expression());
                            break;
                        }
                        case DICTIONARY: {
                            it.at("interpolant", it2 -> builder.interpolation(it2.expression()));
                            it.each("gradient", (key, value) -> builder.addColor((String)key, value.stringValue()));
                        }
                    }
                }));
                break;
            }
            case "minecraft:particle_appearance_lighting": {
                iOFunction = this.parse(BedrockComponent.ParticleLightingAppearance.Builder::new, builder -> {});
                break;
            }
            default: {
                throw new IOException("can't");
            }
        }
        return iOFunction.apply(object);
    }

    protected BedrockEvent parseEventObject(PackObject object) throws IOException {
        BedrockEvent.Builder builder = new BedrockEvent.Builder();
        object.at("expression", it -> builder.expression(it.expression()));
        object.at("sound_effect", it -> builder.sound(it.get("event_name").stringValue()));
        object.at("particle_effect", it -> builder.particle(it.get("effect").stringValue(), it.get("type").stringValue(), it.get("pre_effect_expression").expression()));
        return builder.build();
    }

    protected Object parseShapeDirection(PackObject object) {
        if (object.type() == IODataObject.Type.ARRAY) {
            OpenExpression x = object.at(0).expression();
            OpenExpression y = object.at(1).expression();
            OpenExpression z = object.at(2).expression();
            return Collections.newList(x, y, z);
        }
        return object.stringValue();
    }

    private <T extends BedrockComponent.Builder> IOFunction<PackObject, BedrockComponent> parse(Supplier<T> supplier, @Nullable IOConsumer<T> consumer) {
        return object -> {
            BedrockComponent.Builder builder = (BedrockComponent.Builder)supplier.get();
            if (consumer != null) {
                consumer.accept(builder);
            }
            return builder.build();
        };
    }
}

