/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.io;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.FloatBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.core.IRegistryEntry;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3i;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureAnimation;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureProperties;
import moe.plushie.armourers_workshop.core.utils.OpenPrimitive;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import net.minecraft.nbt.CompoundNBT;

public interface IInputStream {
    public static IInputStream of(InputStream stream) {
        if (stream instanceof DataInputStream) {
            DataInputStream dataInputStream = (DataInputStream)stream;
            return IInputStream.of(dataInputStream);
        }
        return IInputStream.of(new DataInputStream(stream));
    }

    public static IInputStream of(DataInputStream stream) {
        return () -> stream;
    }

    public DataInputStream inputStream();

    default public void skipBytes(int len) throws IOException {
        this.inputStream().skipBytes(len);
    }

    default public void read(byte[] b) throws IOException {
        this.inputStream().readFully(b);
    }

    default public void read(byte[] b, int off, int len) throws IOException {
        this.inputStream().readFully(b, off, len);
    }

    default public void read(FloatBuffer buffer) throws IOException {
        DataInputStream stream = this.inputStream();
        int position = buffer.position();
        int limit = buffer.limit();
        for (int index = position; index < limit; ++index) {
            buffer.put(index, stream.readFloat());
        }
    }

    default public ByteBuf readBytes(int limit) throws IOException {
        byte[] bytes;
        DataInputStream inputStream = this.inputStream();
        ArrayList<byte[]> buffers = new ArrayList<byte[]>();
        for (int remaining = limit; remaining > 0; remaining -= bytes.length) {
            bytes = new byte[Math.min(remaining, 16384)];
            inputStream.readFully(bytes);
            buffers.add(bytes);
        }
        return Unpooled.wrappedBuffer((byte[][])((byte[][])buffers.toArray((T[])new byte[0][])));
    }

    default public byte readByte() throws IOException {
        return this.inputStream().readByte();
    }

    default public boolean readBoolean() throws IOException {
        return this.inputStream().readBoolean();
    }

    default public short readShort() throws IOException {
        return this.inputStream().readShort();
    }

    default public int readInt() throws IOException {
        return this.inputStream().readInt();
    }

    default public long readLong() throws IOException {
        return this.inputStream().readLong();
    }

    default public float readFloat() throws IOException {
        return this.inputStream().readFloat();
    }

    default public double readDouble() throws IOException {
        return this.inputStream().readDouble();
    }

    default public int readFixedInt(int usedBytes) throws IOException {
        if (usedBytes == 4) {
            return this.readInt();
        }
        int value = 0;
        for (int i = 0; i < usedBytes; ++i) {
            int ch = this.readByte() & 0xFF;
            value = value << 8 | ch;
        }
        return value;
    }

    default public float readFixedFloat(int usedBytes) throws IOException {
        return Float.intBitsToFloat(this.readFixedInt(usedBytes));
    }

    default public String readString() throws IOException {
        int size = this.inputStream().readUnsignedShort();
        return this.readString(size);
    }

    default public String readString(int len) throws IOException {
        if (len <= 0) {
            return "";
        }
        byte[] bytes = new byte[len];
        this.inputStream().readFully(bytes, 0, len);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    default public int readVarInt() throws IOException {
        byte b;
        DataInputStream inputStream = this.inputStream();
        int i = 0;
        int j = 0;
        do {
            b = inputStream.readByte();
            i |= (b & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b & 0x80) != 0);
        return i;
    }

    default public float[] readFloatArray(int count) throws IOException {
        float[] results = new float[count];
        for (int i = 0; i < count; ++i) {
            results[i] = this.readFloat();
        }
        return results;
    }

    default public <T extends Enum<?>> T readEnum(Class<T> clazz) throws IOException {
        return (T)((Enum[])clazz.getEnumConstants())[this.readVarInt()];
    }

    default public Optional<String> readOptionalString() throws IOException {
        int len = this.readVarInt();
        if (len == 0) {
            return Optional.empty();
        }
        String value = this.readString(len - 1);
        return Optional.of(value);
    }

    default public OpenPrimitive readPrimitiveObject() throws IOException {
        OpenPrimitive openPrimitive;
        int len = this.readVarInt();
        switch (len) {
            case 0: {
                openPrimitive = OpenPrimitive.NULL;
                break;
            }
            case 1: {
                openPrimitive = OpenPrimitive.FALSE;
                break;
            }
            case 2: {
                openPrimitive = OpenPrimitive.TRUE;
                break;
            }
            case 3: {
                openPrimitive = OpenPrimitive.of(this.readVarInt());
                break;
            }
            case 4: {
                openPrimitive = OpenPrimitive.of(this.readInt());
                break;
            }
            case 5: {
                openPrimitive = OpenPrimitive.of(this.readLong());
                break;
            }
            case 6: {
                openPrimitive = OpenPrimitive.of(this.readFloat());
                break;
            }
            case 7: {
                openPrimitive = OpenPrimitive.of(this.readDouble());
                break;
            }
            default: {
                openPrimitive = OpenPrimitive.of(this.readString(len - 8));
            }
        }
        return openPrimitive;
    }

    default public OpenVector3i readVector3i() throws IOException {
        DataInputStream stream = this.inputStream();
        int x = stream.readInt();
        int y = stream.readInt();
        int z = stream.readInt();
        return new OpenVector3i(x, y, z);
    }

    default public OpenVector3f readVector3f() throws IOException {
        DataInputStream stream = this.inputStream();
        float x = stream.readFloat();
        float y = stream.readFloat();
        float z = stream.readFloat();
        return new OpenVector3f(x, y, z);
    }

    default public OpenRectangle3i readRectangle3i() throws IOException {
        DataInputStream stream = this.inputStream();
        int x = stream.readInt();
        int y = stream.readInt();
        int z = stream.readInt();
        int width = stream.readInt();
        int height = stream.readInt();
        int depth = stream.readInt();
        return new OpenRectangle3i(x, y, z, width, height, depth);
    }

    default public OpenRectangle3f readRectangle3f() throws IOException {
        DataInputStream stream = this.inputStream();
        float x = stream.readFloat();
        float y = stream.readFloat();
        float z = stream.readFloat();
        float width = stream.readFloat();
        float height = stream.readFloat();
        float depth = stream.readFloat();
        return new OpenRectangle3f(x, y, z, width, height, depth);
    }

    default public OpenTransform3f readTransformf() throws IOException {
        OpenTransform3f transform = new OpenTransform3f();
        transform.readFromStream(this);
        if (!transform.equals(OpenTransform3f.IDENTITY)) {
            return transform;
        }
        return OpenTransform3f.IDENTITY;
    }

    default public <T extends IRegistryEntry> T readType(Function<String, T> transform) throws IOException {
        String name = this.readString();
        return (T)((IRegistryEntry)transform.apply(name));
    }

    default public SkinProperties readSkinProperties() throws IOException {
        SkinProperties properties = new SkinProperties();
        properties.readFromStream(this);
        return properties;
    }

    default public SkinTextureAnimation readTextureAnimation() throws IOException {
        SkinTextureAnimation animation = new SkinTextureAnimation();
        animation.readFromStream(this);
        return animation;
    }

    default public SkinTextureProperties readTextureProperties() throws IOException {
        SkinTextureProperties properties = new SkinTextureProperties();
        properties.readFromStream(this);
        return properties;
    }

    default public CompoundNBT readCompoundTag() throws IOException {
        return TagSerializer.parse(this.inputStream());
    }
}

