/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import moe.plushie.armourers_workshop.core.math.OpenVector2f;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkColorSection;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkDataInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkFileData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkTextureData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkVariable;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureData;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenSliceAccessor;

public class ChunkPaletteData
implements ChunkVariable {
    private SkinPaintColor[] paintColors;
    private final LinkedHashMap<Integer, ChunkColorSection> sections = new LinkedHashMap();
    private OpenSliceAccessor<SkinPaintColor> paintColorAccessor;
    private int freezeCount = 0;
    private int colorUsedIndex = 1;
    private int textureUsedIndex = 4;
    private int flags = 0;
    private int reserved = 0;
    private boolean resolved = false;

    public ChunkPaletteData(ChunkFileData fileProvider) {
        fileProvider.addDependency(() -> this.resolved);
    }

    public void copyFrom(ChunkPaletteData palette) {
        this.sections.clear();
        this.sections.putAll(palette.sections);
        this.flags = palette.flags;
        this.reserved = palette.reserved;
        this.colorUsedIndex = palette.colorUsedIndex;
        this.textureUsedIndex = palette.textureUsedIndex;
    }

    public ChunkColorSection.ColorRef writeColor(int rawValue) {
        return this._mutableSectionAt(SkinPaintTypes.NORMAL, 3).putColor(rawValue);
    }

    public ChunkColorSection.ColorRef writeColor(SkinPaintColor color) {
        int rawValue = color.rawValue();
        return this._mutableSectionAt(color.paintType(), 3).putColor(rawValue);
    }

    public SkinPaintColor readColor(int index) {
        if (this.paintColors == null || this.paintColorAccessor == null) {
            return SkinPaintColor.WHITE;
        }
        SkinPaintColor paintColor = this.paintColors[index];
        if (paintColor != null) {
            return paintColor;
        }
        this.paintColors[index] = paintColor = this.paintColorAccessor.get(index);
        return paintColor;
    }

    public SkinPaintColor readColor(ChunkDataInputStream stream) throws IOException {
        return this.readColor(stream.readFixedInt(this.colorUsedIndex));
    }

    public ChunkTextureData.TextureRef writeTexture(OpenVector2f uv, SkinTextureData provider) {
        return this._mutableSectionAt(SkinPaintTypes.TEXTURE, 0).putTexture(uv, provider);
    }

    public ChunkTextureData.TextureRef readTexture(OpenVector2f uv) {
        return this._sectionAt(SkinPaintTypes.TEXTURE, 0).textureRefAt(uv);
    }

    public ChunkTextureData.OptionsRef writeTextureOptions(long options) {
        return this._mutableSectionAt(SkinPaintTypes.TEXTURE, 0).putTextureOptions(options);
    }

    @Override
    public boolean freeze() {
        ++this.freezeCount;
        if (this.freezeCount <= 1) {
            return false;
        }
        if (this.resolved) {
            return true;
        }
        int offset = 0;
        ArrayList<ChunkColorSection> sortedSections = new ArrayList<ChunkColorSection>(this.sections.values());
        sortedSections.sort(Comparator.comparing(this::_key));
        for (ChunkColorSection section : sortedSections) {
            if (!section.isResolved()) {
                section.freeze(offset);
            }
            offset += section.size();
        }
        this.colorUsedIndex = this._used(offset);
        this.textureUsedIndex = 4;
        this.flags = this.colorUsedIndex & 0xF | (this.textureUsedIndex & 0xF) << 4;
        for (ChunkColorSection section : sortedSections) {
            section.freezeIndex(this.colorUsedIndex, this.textureUsedIndex);
        }
        this.resolved = true;
        return true;
    }

    public void readFromStream(ChunkInputStream stream) throws IOException {
        ChunkColorSection section;
        int offset = 0;
        int colorOffset = 0;
        this.flags = stream.readVarInt();
        this.reserved = stream.readVarInt();
        while ((section = this.readSectionFromStream(stream)) != null) {
            this.sections.put(this._key(section), section);
            section.freeze(offset);
            offset += section.size();
            if (section.isTexture()) continue;
            colorOffset += section.size();
        }
        this.paintColors = new SkinPaintColor[colorOffset];
        this.paintColorAccessor = new OpenSliceAccessor<SkinPaintColor>(Collections.compactMap(this.sections.values(), ColorAccessor::new));
        this.colorUsedIndex = this.flags & 0xF;
        this.textureUsedIndex = this.flags >> 4 & 0xF;
    }

    @Override
    public void writeToStream(ChunkOutputStream stream) throws IOException {
        ArrayList<ChunkColorSection> sortedSections = new ArrayList<ChunkColorSection>(this.sections.values());
        sortedSections.sort(Comparator.comparing(ChunkColorSection::startIndex));
        stream.writeVarInt(this.flags);
        stream.writeVarInt(this.reserved);
        for (ChunkColorSection section : sortedSections) {
            this.writeSectionToStream(section, stream);
        }
        this.writeSectionToStream(null, stream);
    }

    private ChunkColorSection readSectionFromStream(ChunkInputStream stream) throws IOException {
        int total = stream.readVarInt();
        if (total == 0) {
            return null;
        }
        SkinPaintType paintType = SkinPaintTypes.byId(stream.readByte());
        byte usedBytes = stream.readByte();
        ChunkColorSection.Immutable section = new ChunkColorSection.Immutable(total, usedBytes, paintType);
        section.readFromStream(stream);
        return section;
    }

    private void writeSectionToStream(ChunkColorSection section, ChunkOutputStream stream) throws IOException {
        if (section == null) {
            stream.writeVarInt(0);
            return;
        }
        stream.writeVarInt(section.size());
        stream.writeByte(section.paintType().id());
        stream.writeByte(section.usedBytes());
        section.writeToStream(stream);
    }

    public int colorIndexBytes() {
        return this.colorUsedIndex;
    }

    public int textureIndexBytes() {
        return this.textureUsedIndex;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    private Integer _key(ChunkColorSection section) {
        return section.paintType().id() << 24 | section.usedBytes();
    }

    private ChunkColorSection _sectionAt(SkinPaintType paintType, int usedBytes) {
        return this.sections.get(paintType.id() << 24 | usedBytes);
    }

    private ChunkColorSection.Mutable _mutableSectionAt(SkinPaintType paintType, int usedBytes) {
        return (ChunkColorSection.Mutable)this.sections.computeIfAbsent(paintType.id() << 24 | usedBytes, k -> new ChunkColorSection.Mutable(usedBytes, paintType));
    }

    private int _used(int size) {
        for (int i = 1; i < 4; ++i) {
            if (size >>> i * 8 != 0) continue;
            return i;
        }
        return 4;
    }

    public static class ColorAccessor
    implements OpenSliceAccessor.Provider<SkinPaintColor> {
        private final ChunkColorSection section;

        public ColorAccessor(ChunkColorSection section) {
            this.section = section;
        }

        @Override
        public SkinPaintColor get(int index) {
            return this.section.colorAt(index);
        }

        @Override
        public int startIndex() {
            return this.section.startIndex();
        }

        @Override
        public int endIndex() {
            return this.section.endIndex();
        }
    }
}

