/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.core.skin.SkinPreviewData;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometrySet;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkDataInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkDataOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkGeometryData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkTransform;
import org.apache.commons.lang3.tuple.Pair;

public class ChunkPreviewData {
    private final ChunkGeometryData geometryData;

    public ChunkPreviewData(ChunkGeometryData geometryData) {
        this.geometryData = geometryData;
    }

    public SkinPreviewData readFromStream(ChunkDataInputStream stream) throws IOException {
        int count;
        ChunkTransform chunkTransform = new ChunkTransform();
        ArrayList sections = new ArrayList();
        while ((count = stream.readVarInt()) != 0) {
            int id = stream.readVarInt();
            chunkTransform.readFromStream(stream);
            for (int i = 0; i < count; ++i) {
                SkinGeometrySet<?> geometries = this.geometryData.readReferenceFromStream(stream);
                sections.add(Pair.of((Object)chunkTransform.build(), geometries));
            }
        }
        return new SkinPreviewData(sections);
    }

    public void writeToStream(SkinPreviewData previewData, ChunkDataOutputStream stream) throws IOException {
        LinkedHashMap sections = new LinkedHashMap();
        previewData.forEach((transform, geometries) -> {
            ChunkTransform chunkTransform = ChunkTransform.flat(transform);
            sections.computeIfAbsent(chunkTransform, k -> new ArrayList()).add(geometries);
        });
        for (Map.Entry section : sections.entrySet()) {
            stream.writeVarInt(((ArrayList)section.getValue()).size());
            stream.writeVarInt(0);
            ((ChunkTransform)section.getKey()).writeToStream(stream);
            for (SkinGeometrySet geometries2 : (ArrayList)section.getValue()) {
                this.geometryData.writeReferenceToStream(geometries2, stream);
            }
        }
        stream.writeVarInt(0);
    }
}

