/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenRectangle2f;
import moe.plushie.armourers_workshop.core.math.OpenVector2f;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkColorSection;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkFile;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkVariable;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureAnimation;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureData;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureProperties;
import moe.plushie.armourers_workshop.core.utils.Collections;

public class ChunkTextureData {
    private static final SkinProperty<List<Float>> USED_RECT_KEY = SkinProperty.normal("usedRect", null);
    protected OpenRectangle2f rect = OpenRectangle2f.ZERO;
    protected OpenRectangle2f usedRect = OpenRectangle2f.ZERO;
    protected SkinTextureData provider;
    protected boolean isResolved = false;
    protected int id = 0;
    protected int parentId = 0;
    private final ArrayList<TextureRef> uvs = new ArrayList();

    public ChunkTextureData() {
    }

    public ChunkTextureData(SkinTextureData provider) {
        this.usedRect = this.rect = new OpenRectangle2f(0.0f, 0.0f, provider.width(), provider.height());
        this.provider = provider;
    }

    public void readFromStream(ChunkInputStream stream) throws IOException {
        this.id = stream.readVarInt();
        this.parentId = stream.readVarInt();
        if (this.id == 0) {
            // empty if block
        }
        float x = stream.readFloat();
        float y = stream.readFloat();
        float width = stream.readFloat();
        float height = stream.readFloat();
        this.usedRect = this.rect = new OpenRectangle2f(x, y, width, height);
        SkinTextureAnimation animation = stream.readTextureAnimation();
        SkinTextureProperties properties = this.readAdditionalData(stream.readTextureProperties());
        ChunkFile file = stream.readFile();
        SkinTextureData provider = new SkinTextureData(file.name(), width, height, animation, properties);
        provider.load(file.bytes());
        this.provider = provider;
    }

    public void writeToStream(ChunkOutputStream stream) throws IOException {
        stream.writeVarInt(this.id);
        stream.writeVarInt(this.parentId);
        if (this.id == 0) {
            // empty if block
        }
        stream.writeFloat(this.rect.x());
        stream.writeFloat(this.rect.y());
        stream.writeFloat(this.rect.width());
        stream.writeFloat(this.rect.height());
        stream.writeTextureAnimation(this.provider.animation());
        stream.writeTextureProperties(this.writeAdditionalData(this.provider.properties()));
        stream.writeFile(ChunkFile.image(this.provider.name(), this.provider.buffer()));
    }

    public void freeze(float x, float y, Function<SkinTextureData, ChunkTextureData> childProvider) {
        Collections.compactMap(this.provider.variants(), childProvider).forEach(it -> {
            it.parentId = this.id;
        });
        float minX = (float)OpenMath.floori((this.usedRect.minX() - this.rect.minX()) / 16.0f) * 16.0f;
        float minY = (float)OpenMath.floori((this.usedRect.minY() - this.rect.minY()) / 16.0f) * 16.0f;
        float maxX = (float)OpenMath.ceili((this.usedRect.maxX() - this.rect.minX()) / 16.0f) * 16.0f;
        float maxY = (float)OpenMath.ceili((this.usedRect.maxY() - this.rect.minY()) / 16.0f) * 16.0f;
        this.rect = new OpenRectangle2f(x - minX, y - minY, this.rect.width(), this.rect.height());
        this.usedRect = new OpenRectangle2f(x, y, maxX - minX, maxY - minY);
        this.isResolved = true;
    }

    public boolean contains(OpenVector2f uv) {
        return this.usedRect.contains(uv);
    }

    public TextureRef get(OpenVector2f uv, ChunkColorSection section) {
        return new TextureRef(section, this, new OpenVector2f(uv.x() - this.rect.x(), uv.y() - this.rect.y()));
    }

    public TextureRef add(OpenVector2f uv, ChunkColorSection section) {
        TextureRef ref = new TextureRef(section, this, uv);
        if (!this.usedRect.contains(uv)) {
            float x0 = Math.min(this.usedRect.minX(), uv.x());
            float y0 = Math.min(this.usedRect.minY(), uv.y());
            float x1 = Math.max(this.usedRect.maxX(), uv.x());
            float y1 = Math.max(this.usedRect.maxY(), uv.y());
            this.usedRect = new OpenRectangle2f(x0, y0, x1 - x0, y1 - y0);
        }
        this.uvs.add(ref);
        return ref;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int id() {
        return this.id;
    }

    public OpenRectangle2f rect() {
        return this.rect;
    }

    public OpenRectangle2f usedRect() {
        return this.usedRect;
    }

    public SkinTextureData texture() {
        return this.provider;
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    private SkinTextureProperties readAdditionalData(SkinTextureProperties properties) {
        List<Float> rectValues = properties.get(USED_RECT_KEY);
        if (rectValues != null) {
            float x = rectValues.get(0).floatValue();
            float y = rectValues.get(1).floatValue();
            float w = rectValues.get(2).floatValue();
            float h = rectValues.get(3).floatValue();
            this.usedRect = new OpenRectangle2f(x, y, w, h);
        }
        return properties;
    }

    private SkinTextureProperties writeAdditionalData(SkinTextureProperties properties) {
        if (!this.rect.equals(this.usedRect)) {
            float x = this.usedRect.x();
            float y = this.usedRect.y();
            float w = this.usedRect.width();
            float h = this.usedRect.height();
            SkinTextureProperties newProperties = properties.copy();
            newProperties.set(USED_RECT_KEY, Collections.newList(Float.valueOf(x), Float.valueOf(y), Float.valueOf(w), Float.valueOf(h)));
            properties = newProperties;
        }
        return properties;
    }

    public static class TextureRef
    implements ChunkVariable {
        private final OpenVector2f uv;
        private final ChunkTextureData list;
        private final ChunkColorSection section;

        public TextureRef(ChunkColorSection section, ChunkTextureData list, OpenVector2f uv) {
            this.section = section;
            this.list = list;
            this.uv = uv;
        }

        @Override
        public void writeToStream(ChunkOutputStream stream) throws IOException {
            OpenRectangle2f rect = this.list.rect();
            stream.writeFixedFloat(rect.x() + this.uv.x(), this.section.textureIndexBytes);
            stream.writeFixedFloat(rect.y() + this.uv.y(), this.section.textureIndexBytes);
        }

        @Override
        public boolean freeze() {
            return this.section.isResolved() && this.list.isResolved();
        }

        public float u() {
            return this.uv.x();
        }

        public float v() {
            return this.uv.y();
        }

        public OpenVector2f uv() {
            return this.uv;
        }

        public SkinTextureData provider() {
            return this.list.provider;
        }
    }

    public static class OptionsRef
    implements ChunkVariable {
        private final long value;
        private final ChunkColorSection section;

        public OptionsRef(ChunkColorSection section, long value) {
            this.value = value;
            this.section = section;
        }

        @Override
        public void writeToStream(ChunkOutputStream stream) throws IOException {
            stream.writeFixedInt((int)this.value, this.section.textureIndexBytes);
            stream.writeFixedInt((int)(this.value >> 32), this.section.textureIndexBytes);
        }

        @Override
        public boolean freeze() {
            return this.section.isResolved();
        }
    }
}

