/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import moe.plushie.armourers_workshop.core.utils.Collections;
import org.apache.commons.io.FilenameUtils;

public class FileUtils {
    public static List<File> listFiles(File directory) {
        try {
            File[] files = directory.listFiles();
            if (files != null) {
                return Collections.newList(files);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public static List<File> listFilesRecursive(File directory) {
        ArrayList<File> allFiles = new ArrayList<File>();
        allFiles.add(directory);
        for (int i = 0; i < allFiles.size(); ++i) {
            File path = (File)allFiles.get(i);
            if (!path.isDirectory()) continue;
            allFiles.addAll(FileUtils.listFiles(path));
        }
        allFiles.remove(0);
        return allFiles;
    }

    public static void forceMkdir(File directory) throws IOException {
        org.apache.commons.io.FileUtils.forceMkdir((File)directory);
    }

    public static void forceMkdirParent(File file) throws IOException {
        File parent = file.getParentFile();
        if (parent != null) {
            FileUtils.forceMkdir(parent);
        }
    }

    public static boolean deleteQuietly(File file) {
        return org.apache.commons.io.FileUtils.deleteQuietly((File)file);
    }

    public static String normalize(String filename) {
        return FilenameUtils.normalize((String)filename);
    }

    public static String normalize(String filename, boolean unixSeparator) {
        return FilenameUtils.normalize((String)filename, (boolean)unixSeparator);
    }

    public static String normalizeNoEndSeparator(String filename, boolean unixSeparator) {
        return FilenameUtils.normalizeNoEndSeparator((String)filename, (boolean)unixSeparator);
    }

    public static String concat(String basePath, String fullFilenameToAdd) {
        return FilenameUtils.concat((String)basePath, (String)fullFilenameToAdd);
    }

    public static String getBaseName(String filename) {
        return FilenameUtils.getBaseName((String)filename);
    }

    public static String getRegistryName(String path, String rootPath) {
        if (path.startsWith(rootPath)) {
            return path.substring(rootPath.length());
        }
        return path;
    }

    public static String removeExtension(String filename) {
        return FilenameUtils.removeExtension((String)filename);
    }

    public static String getExtension(String filename) {
        return FilenameUtils.getExtension((String)filename);
    }

    public static String getRelativePath(String path, String rootPath) {
        if (path.equals(rootPath)) {
            return "/";
        }
        if (path.startsWith(rootPath)) {
            return path.substring(rootPath.length());
        }
        return path;
    }

    public static String getRelativePath(String path, String rootPath, boolean unixSeparator) {
        return FileUtils.normalize(FileUtils.getRelativePath(path, rootPath), unixSeparator);
    }

    public static String getRelativePath(File path, File rootPath) {
        return FileUtils.getRelativePath(path.getAbsolutePath(), rootPath.getAbsolutePath());
    }

    public static String getRelativePath(File path, File rootPath, boolean unixSeparator) {
        return FileUtils.normalize(FileUtils.getRelativePath(path, rootPath), unixSeparator);
    }

    public static void setLastModifiedTime(File path, long time) {
        boolean ignored = path.setLastModified(time);
    }

    public static long getLastModifiedTime(File path) {
        return path.lastModified();
    }

    public static long getCreationTime(File path) {
        try {
            BasicFileAttributes attrs = Files.readAttributes(path.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            return attrs.creationTime().toMillis();
        }
        catch (IOException e) {
            return 0L;
        }
    }
}

