/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.utils;

import java.util.Optional;
import java.util.function.Supplier;

public class LazyOptional<T> {
    private static final LazyOptional<Void> EMPTY = new LazyOptional(null);
    private Optional<T> value;
    private Supplier<Optional<T>> provider;

    public LazyOptional(Supplier<Optional<T>> provider) {
        this.provider = provider;
    }

    public static <T> LazyOptional<T> of(Supplier<Optional<T>> provider) {
        return new LazyOptional<T>(provider);
    }

    public static <T> LazyOptional<T> ofNullable(Supplier<T> provider) {
        return new LazyOptional<T>(() -> Optional.ofNullable(provider.get()));
    }

    public static <T> LazyOptional<T> empty() {
        return EMPTY;
    }

    public Optional<T> resolve() {
        if (this.provider != null) {
            this.value = this.provider.get();
            this.provider = null;
        }
        return this.value;
    }
}

