/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.utils;

import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface OpenInteractionResult {
    public static final Success SUCCESS = new Success(SwingSource.CLIENT, ItemContext.DEFAULT);
    public static final Success SUCCESS_SERVER = new Success(SwingSource.SERVER, ItemContext.DEFAULT);
    public static final Success CONSUME = new Success(SwingSource.NONE, ItemContext.DEFAULT);
    public static final Fail FAIL = new Fail();
    public static final Pass PASS = new Pass();
    public static final TryEmptyHandInteraction TRY_WITH_EMPTY_HAND = new TryEmptyHandInteraction();

    default public boolean consumesAction() {
        return false;
    }

    public static Success sidedSuccess(boolean bl) {
        return bl ? SUCCESS : CONSUME;
    }

    public static final class Success
    implements OpenInteractionResult {
        private final SwingSource swingSource;
        private final ItemContext itemContext;

        public Success(SwingSource swingSource, ItemContext itemContext) {
            this.swingSource = swingSource;
            this.itemContext = itemContext;
        }

        @Override
        public boolean consumesAction() {
            return true;
        }

        public Success heldItemTransformedTo(ItemStack itemStack) {
            return new Success(this.swingSource, new ItemContext(true, itemStack));
        }

        public Success withoutItem() {
            return new Success(this.swingSource, ItemContext.NONE);
        }

        public boolean wasItemInteraction() {
            return this.itemContext.wasItemInteraction;
        }

        @Nullable
        public ItemStack heldItemTransformedTo() {
            return this.itemContext.heldItemTransformedTo;
        }

        public SwingSource swingSource() {
            return this.swingSource;
        }

        public ItemContext itemContext() {
            return this.itemContext;
        }
    }

    public static enum SwingSource {
        NONE,
        CLIENT,
        SERVER;

    }

    public static class ItemContext {
        private final boolean wasItemInteraction;
        private final ItemStack heldItemTransformedTo;
        static ItemContext NONE = new ItemContext(false, null);
        static ItemContext DEFAULT = new ItemContext(true, null);

        public ItemContext(boolean bl, @Nullable ItemStack itemStack) {
            this.wasItemInteraction = bl;
            this.heldItemTransformedTo = itemStack;
        }

        public boolean wasItemInteraction() {
            return this.wasItemInteraction;
        }

        @Nullable
        public ItemStack heldItemTransformedTo() {
            return this.heldItemTransformedTo;
        }
    }

    public static final class Fail
    implements OpenInteractionResult {
    }

    public static final class Pass
    implements OpenInteractionResult {
    }

    public static final class TryEmptyHandInteraction
    implements OpenInteractionResult {
    }
}

