/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class OpenSliceAccessor<T> {
    private int selectedIndex;
    private int startIndex;
    private int endIndex;
    private Provider<? extends T> selected;
    private final int count;
    private final List<Provider<? extends T>> slices;

    public OpenSliceAccessor(List<Provider<? extends T>> slices) {
        this.slices = this.checkOrder(slices);
        this.count = slices.size();
        if (this.count != 0) {
            this.switchSlice(0);
        }
    }

    public T get(int index) {
        return this.sliceAt(index).get(index - this.startIndex);
    }

    private Provider<? extends T> sliceAt(int index) {
        int cursor = this.selectedIndex;
        while (true) {
            if (index < this.startIndex) {
                --cursor;
            } else if (index >= this.endIndex) {
                ++cursor;
            } else {
                return this.selected;
            }
            if (cursor < 0 || cursor >= this.count) break;
            this.switchSlice(cursor);
        }
        throw new IndexOutOfBoundsException("Index out of range: " + index);
    }

    private void switchSlice(int selectedIndex) {
        this.selected = this.slices.get(selectedIndex);
        this.selectedIndex = selectedIndex;
        this.startIndex = this.selected.startIndex();
        this.endIndex = this.selected.endIndex();
    }

    private List<Provider<? extends T>> checkOrder(List<Provider<? extends T>> slices) {
        ArrayList<Provider<T>> sortedSlices = new ArrayList<Provider<T>>(slices);
        sortedSlices.sort(Comparator.comparingInt(Provider::startIndex));
        return sortedSlices;
    }

    public static interface Provider<T> {
        public T get(int var1);

        public int startIndex();

        public int endIndex();
    }
}

