/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.utils;

import java.util.Collection;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.skin.part.features.ICanOverride;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.Fix16;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.core.math.OpenVector4f;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.GameRules;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.Nullable;

public final class SkinUtils {
    public static Collection<String> getItemOverrides(SkinPartType partType) {
        ICanOverride override = Objects.safeCast(partType, ICanOverride.class);
        if (override != null) {
            return override.itemOverrides();
        }
        return Collections.emptyList();
    }

    public static boolean shouldKeepWardrobe(PlayerEntity entity) {
        if (entity.func_175149_v()) {
            return true;
        }
        int keep = ModConfig.Common.prefersWardrobeDropOnDeath;
        if (keep == 1) {
            return true;
        }
        if (keep == 2) {
            return false;
        }
        return PropertyProvider.getLevel((Entity)entity).func_82736_K().func_223586_b(GameRules.field_223600_c);
    }

    public static void dropAllIfNeeded(PlayerEntity player) {
        if (SkinUtils.shouldKeepWardrobe(player)) {
            return;
        }
        SkinWardrobe oldWardrobe = SkinWardrobe.of((Entity)player);
        if (oldWardrobe != null) {
            oldWardrobe.dropAll(arg_0 -> ((PlayerEntity)player).func_199701_a_(arg_0));
            oldWardrobe.broadcast();
        }
    }

    public static <T extends Entity> Consumer<T> appendSkinIntoEntity(Consumer<T> consumer, ServerWorld serverLevel, ItemStack itemStack, @Nullable PlayerEntity player) {
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (descriptor.isEmpty()) {
            return consumer;
        }
        return consumer.andThen(entity -> {
            if (!(entity instanceof BoatEntity) && !(entity instanceof AbstractMinecartEntity)) {
                return;
            }
            SkinWardrobe wardrobe = SkinWardrobe.of(entity);
            if (wardrobe != null) {
                wardrobe.setItem(SkinSlotType.ANY, 0, descriptor.asItemStack());
                wardrobe.broadcast();
            }
        });
    }

    public static <T extends Entity> Consumer<ItemStack> appendSkinIntoItemStack(Consumer<ItemStack> consumer, T entity) {
        if (!(entity instanceof BoatEntity) && !(entity instanceof AbstractMinecartEntity)) {
            return consumer;
        }
        SkinWardrobe wardrobe = SkinWardrobe.of(entity);
        if (wardrobe == null) {
            return consumer;
        }
        ItemStack itemStack1 = wardrobe.getItem(SkinSlotType.ANY, 0);
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack1);
        if (descriptor.isEmpty()) {
            return consumer;
        }
        return consumer.andThen(itemStack -> ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.SKIN.get(), descriptor));
    }

    public static void copySkinWardrobe(Entity from, Entity to) {
        SkinWardrobe oldWardrobe = SkinWardrobe.of(from);
        SkinWardrobe newWardrobe = SkinWardrobe.of(to);
        if (newWardrobe != null && oldWardrobe != null) {
            TagSerializer serializer = new TagSerializer(new CompoundNBT(), to);
            oldWardrobe.serialize(serializer);
            newWardrobe.deserialize(serializer);
            if (!PropertyProvider.getLevel(to).func_201670_d()) {
                newWardrobe.broadcast();
            }
        }
    }

    public static void copySkinFromOwner(Entity entity) {
        ProjectileEntity projectile = Objects.safeCast(entity, ProjectileEntity.class);
        if (projectile == null) {
            return;
        }
        Entity owner = projectile.func_234616_v_();
        if (entity instanceof TridentEntity) {
            SkinUtils.copySkin(owner, entity, SkinSlotType.TRIDENT, 0, SkinSlotType.ANY, 0);
            return;
        }
        if (entity instanceof AbstractArrowEntity) {
            SkinUtils.copySkin(owner, entity, SkinSlotType.BOW, 0, SkinSlotType.ANY, 0);
            return;
        }
        if (entity instanceof FishingBobberEntity && owner instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)owner;
            ItemStack itemStack = livingEntity.func_184614_ca();
            if (!Fix16.is(itemStack, Items.field_151112_aM)) {
                itemStack = livingEntity.func_184592_cb();
            }
            SkinUtils.copySkin(entity, itemStack, SkinSlotType.ANY, 0);
            return;
        }
    }

    public static void copySkin(Entity src, Entity dest, SkinSlotType fromSlotType, int fromIndex, SkinSlotType toSlotType, int toIndex) {
        ItemStack itemStack = SkinUtils.getSkin(src, fromSlotType, fromIndex);
        if (itemStack.func_190926_b()) {
            return;
        }
        SkinUtils.copySkin(dest, itemStack, toSlotType, toIndex);
    }

    public static void copySkin(Entity dest, ItemStack itemStack, SkinSlotType toSlotType, int toIndex) {
        SkinWardrobe wardrobe = SkinWardrobe.of(dest);
        if (wardrobe != null) {
            wardrobe.setItem(toSlotType, toIndex, itemStack.func_77946_l());
            wardrobe.broadcast();
        }
    }

    public static ItemStack getSkin(Entity entity, SkinSlotType slotType, int index) {
        ItemStack itemStack = ItemStack.field_190927_a;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            itemStack = SkinUtils.getUsingItem(livingEntity);
        }
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (Objects.equals(slotType.skinType(), descriptor.type())) {
            return itemStack;
        }
        SkinWardrobe wardrobe = SkinWardrobe.of(entity);
        if (wardrobe != null) {
            ItemStack itemStack1 = wardrobe.getItem(slotType, index);
            descriptor = SkinDescriptor.of(itemStack1);
            if (Objects.equals(slotType.skinType(), descriptor.type())) {
                return itemStack1;
            }
        }
        return ItemStack.field_190927_a;
    }

    private static ItemStack getUsingItem(LivingEntity entity) {
        ItemStack itemStack = entity.func_184607_cu();
        if (!itemStack.func_190926_b()) {
            return itemStack;
        }
        itemStack = entity.func_184614_ca();
        if (Fix16.is(itemStack, Items.field_222114_py) && CrossbowItem.func_220012_d((ItemStack)itemStack)) {
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    private static int getSkinIndex(String partIndexProp, Skin skin, int partIndex) {
        String[] split = partIndexProp.split(":");
        for (int i = 0; i < split.length; ++i) {
            int count = Integer.parseInt(split[i]);
            if (partIndex >= count) continue;
            return i;
        }
        return -1;
    }

    public static VoxelShape apply(VoxelShape shape, OpenMatrix4f matrix) {
        float minX = (float)shape.func_197762_b(Direction.Axis.X);
        float minY = (float)shape.func_197762_b(Direction.Axis.Y);
        float minZ = (float)shape.func_197762_b(Direction.Axis.Z);
        float maxX = (float)shape.func_197758_c(Direction.Axis.X);
        float maxY = (float)shape.func_197758_c(Direction.Axis.Y);
        float maxZ = (float)shape.func_197758_c(Direction.Axis.Z);
        OpenVector4f[] points = new OpenVector4f[]{new OpenVector4f(minX, minY, minZ, 1.0f), new OpenVector4f(maxX, minY, minZ, 1.0f), new OpenVector4f(maxX, maxY, minZ, 1.0f), new OpenVector4f(minX, maxY, minZ, 1.0f), new OpenVector4f(minX, minY, maxZ, 1.0f), new OpenVector4f(maxX, minY, maxZ, 1.0f), new OpenVector4f(maxX, maxY, maxZ, 1.0f), new OpenVector4f(minX, maxY, maxZ, 1.0f)};
        boolean isReset = false;
        for (OpenVector4f point : points) {
            point.transform(matrix);
            if (isReset) {
                minX = Math.min(minX, point.x());
                minY = Math.min(minY, point.y());
                minZ = Math.min(minZ, point.z());
                maxX = Math.max(maxX, point.x());
                maxY = Math.max(maxY, point.y());
                maxZ = Math.max(maxZ, point.z());
                continue;
            }
            minX = point.x();
            minY = point.y();
            minZ = point.z();
            maxX = point.x();
            maxY = point.y();
            maxZ = point.z();
            isReset = true;
        }
        return VoxelShapes.func_197873_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    private static float[][][] reorder(float[][][] values, int ... indexes) {
        float[][][] newValues = new float[values.length][][];
        for (int i = 0; i < values.length; ++i) {
            float[][] faces = values[i];
            float[][] newFaces = new float[faces.length][];
            for (int j = 0; j < faces.length; ++j) {
                if (j < indexes.length) {
                    newFaces[indexes[j]] = faces[j];
                    continue;
                }
                newFaces[j] = faces[j];
            }
            newValues[i] = newFaces;
        }
        return newValues;
    }
}

