/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.utils;

import moe.plushie.armourers_workshop.core.utils.OpenClock;

public class TickUtils {
    private static final Timer TIMER = new Timer();

    public static void tick(boolean isPaused) {
        TIMER.tick(isPaused);
    }

    public static void setTime(long time) {
        TIMER.setTime(time);
    }

    public static void setSpeed(float speed) {
        TIMER.setSpeed(speed);
    }

    public static double animationTicks() {
        return TIMER.animationTicks;
    }

    public static double animationTicksByTime(long time) {
        double delta = (double)(time - TIMER.clock.time()) / 1000.0;
        return TIMER.animationTicks + delta;
    }

    private static class Timer {
        private final OpenClock clock = new OpenClock();
        private double baseTicks = 0.0;
        private double animationTicks = 0.0;
        private double modulator = 0.001;
        private long serverTime = 0L;
        private long lastTime = 0L;
        private boolean isPaused = false;

        private Timer() {
        }

        public void tick(boolean isPaused) {
            if (this.isPaused != isPaused) {
                this.isPaused = isPaused;
                this.reset();
                return;
            }
            if (isPaused) {
                return;
            }
            long time = this.clock.time();
            double delta = (double)(time - this.lastTime) * this.modulator;
            this.animationTicks = this.baseTicks + delta;
        }

        public void setTime(long time) {
            this.clock.setTime(time);
            this.serverTime = time;
            this.animationTicks = 0.0;
            this.reset();
        }

        public void setSpeed(float speed) {
            this.modulator = (double)speed / 1000.0;
            this.reset();
        }

        private void reset() {
            this.baseTicks = this.animationTicks;
            this.lastTime = this.clock.time();
        }
    }
}

