/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.command;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import moe.plushie.armourers_workshop.api.common.IArgumentSerializer;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintType;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.init.command.ColorSchemeParser;
import net.minecraft.command.CommandSource;

public class ColorSchemeArgumentType
implements ArgumentType<SkinPaintScheme> {
    private static final Collection<String> EXAMPLES = Collections.newList("<dyeIndex=[paintType:]#RRGGBB>", "<dyeIndex=[paintType:]R,G,B>");

    public static SkinPaintScheme getColorScheme(CommandContext<CommandSource> context, String name) {
        return (SkinPaintScheme)context.getArgument(name, SkinPaintScheme.class);
    }

    public SkinPaintScheme parse(StringReader reader) throws CommandSyntaxException {
        ColorSchemeParser parser = new ColorSchemeParser(reader).parse();
        SkinPaintScheme colorScheme = new SkinPaintScheme();
        for (Map.Entry<SkinPaintType, SkinPaintColor> entry : parser.properties().entrySet()) {
            colorScheme.setColor(entry.getKey(), entry.getValue());
        }
        return colorScheme;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        StringReader stringReader = new StringReader(builder.getInput());
        stringReader.setCursor(builder.getStart());
        ColorSchemeParser parser = new ColorSchemeParser(stringReader);
        try {
            parser.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return parser.fillSuggestions(builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static class Serializer
    implements IArgumentSerializer<ColorSchemeArgumentType> {
        @Override
        public void serializeToNetwork(ColorSchemeArgumentType argument, IFriendlyByteBuf buffer) {
        }

        @Override
        public ColorSchemeArgumentType deserializeFromNetwork(IFriendlyByteBuf buffer) {
            return new ColorSchemeArgumentType();
        }

        @Override
        public void serializeToJson(ColorSchemeArgumentType argument, JsonObject json) {
        }
    }
}

