/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.proxy;

import java.util.stream.Stream;
import moe.plushie.armourers_workshop.api.common.IBlockTintColorProvider;
import moe.plushie.armourers_workshop.api.common.IItemModelProperty;
import moe.plushie.armourers_workshop.api.common.IItemPropertiesProvider;
import moe.plushie.armourers_workshop.api.common.IItemTintColorProvider;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.api.event.EventBus;
import moe.plushie.armourers_workshop.builder.client.render.PaintingHighlightPlacementRenderer;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.Fix16;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.bake.SkinPreloadManager;
import moe.plushie.armourers_workshop.core.client.render.HighlightPlacementRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRendererManager;
import moe.plushie.armourers_workshop.core.client.sound.SmartSoundManager;
import moe.plushie.armourers_workshop.core.client.texture.EntityTextureLoader;
import moe.plushie.armourers_workshop.core.client.texture.SmartTextureManager;
import moe.plushie.armourers_workshop.core.data.DataPackLoader;
import moe.plushie.armourers_workshop.core.data.DataPackType;
import moe.plushie.armourers_workshop.core.data.cache.AutoreleasePool;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenItemDisplayContext;
import moe.plushie.armourers_workshop.core.utils.Scheduler;
import moe.plushie.armourers_workshop.core.utils.SkinUtils;
import moe.plushie.armourers_workshop.core.utils.TickUtils;
import moe.plushie.armourers_workshop.core.utils.TypedRegistry;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModConfigSpec;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.ModContext;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.init.ModEntityProfiles;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModKeyBindings;
import moe.plushie.armourers_workshop.init.client.ClientWardrobeHandler;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.environment.EnvironmentType;
import moe.plushie.armourers_workshop.init.event.client.ClientPlayerEvent;
import moe.plushie.armourers_workshop.init.event.client.ItemTooltipEvent;
import moe.plushie.armourers_workshop.init.event.client.RegisterColorHandlersEvent;
import moe.plushie.armourers_workshop.init.event.client.RegisterItemPropertyEvent;
import moe.plushie.armourers_workshop.init.event.client.RegisterTextureEvent;
import moe.plushie.armourers_workshop.init.event.client.RenderFrameEvent;
import moe.plushie.armourers_workshop.init.event.client.RenderHighlightEvent;
import moe.plushie.armourers_workshop.init.event.client.RenderLivingEntityEvent;
import moe.plushie.armourers_workshop.init.event.client.RenderSpecificHandEvent;
import moe.plushie.armourers_workshop.init.platform.DataPackManager;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.init.platform.ItemTooltipManager;
import moe.plushie.armourers_workshop.library.data.GlobalSkinLibrary;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import moe.plushie.armourers_workshop.library.data.impl.MinecraftAuth;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Hand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy {
    public static void init() {
        ClientWardrobeHandler.init();
        SkinRendererManager.init();
        ModKeyBindings.init();
        ModDebugger.init();
        MinecraftAuth.init(new MinecraftAuth.UserProvider(){

            @Override
            public String id() {
                return Minecraft.func_71410_x().func_110432_I().func_148255_b();
            }

            @Override
            public String name() {
                return Minecraft.func_71410_x().func_110432_I().func_111285_a();
            }

            @Override
            public String accessToken() {
                return Minecraft.func_71410_x().func_110432_I().func_148254_d();
            }
        });
        EnvironmentExecutor.willSetup(EnvironmentType.CLIENT, () -> () -> {
            IResourceManager resourceManager = Minecraft.func_71410_x().func_195551_G();
            DataPackLoader packLoader = DataPackManager.byType(DataPackType.CLIENT_RESOURCES);
            ((IReloadableResourceManager)resourceManager).func_219534_a((IFutureReloadListener)packLoader);
        });
        ClientProxy.register();
    }

    private static void register() {
        EventBus.register(RegisterItemPropertyEvent.class, event -> TypedRegistry.findEntries(Item.class).forEach(it -> {
            Item item = (Item)it.get();
            if (item instanceof IItemPropertiesProvider) {
                IItemPropertiesProvider provider = (IItemPropertiesProvider)item;
                provider.createModelProperties((key, property) -> event.register((IResourceLocation)key, item, (IItemModelProperty)property));
            }
            event.register(ModConstants.key("is_crossbow"), Items.field_222114_py, (itemStack, level, entity, id) -> 1.0f);
            event.register(ModConstants.key("is_skin"), (Item)ModItems.SKIN.get(), (itemStack, level, entity, id) -> {
                MannequinEntity mannequin;
                if (entity instanceof MannequinEntity && (itemStack == (mannequin = (MannequinEntity)entity).func_184614_ca() || itemStack == mannequin.func_184592_cb())) {
                    return 0.0f;
                }
                return 1.0f;
            });
        }));
        EventBus.register(RegisterColorHandlersEvent.Item.class, event -> TypedRegistry.findEntries(Item.class).forEach(it -> {
            Item item = (Item)it.get();
            if (item instanceof IItemTintColorProvider) {
                IItemTintColorProvider provider = (IItemTintColorProvider)item;
                event.register(provider, item);
            }
        }));
        EventBus.register(RegisterColorHandlersEvent.Block.class, event -> TypedRegistry.findEntries(Block.class).forEach(it -> {
            Block block = (Block)it.get();
            if (block instanceof IBlockTintColorProvider) {
                IBlockTintColorProvider provider = (IBlockTintColorProvider)block;
                event.register(provider, block);
            }
        }));
        EventBus.register(RegisterTextureEvent.class, event -> Stream.of(SkinSlotType.values()).forEach(slotType -> event.register(slotType.icon())));
        EventBus.register(ClientPlayerEvent.LoggingIn.class, event -> {
            PlayerEntity player = event.getPlayer();
            if (player == null || !player.equals((Object)EnvironmentManager.getPlayer())) {
                return;
            }
            SkinBakery.start();
            SkinPreloadManager.start();
            SmartSoundManager.getInstance().start();
            SmartTextureManager.getInstance().start();
            EntityTextureLoader.getInstance().start();
        });
        EventBus.register(ClientPlayerEvent.LoggingOut.class, event -> {
            PlayerEntity player = event.getPlayer();
            if (player == null || !player.equals((Object)EnvironmentManager.getPlayer())) {
                return;
            }
            SkinPreloadManager.stop();
            SkinBakery.stop();
            Tickets.invalidateAll();
            EntityTextureLoader.getInstance().stop();
            SmartSoundManager.getInstance().stop();
            SmartTextureManager.getInstance().stop();
            SkinLoader.getInstance().stop();
            GlobalSkinLibrary.getInstance().disconnect();
            SkinLibraryManager.getClient().publicLibrary().reset();
            SkinLibraryManager.getClient().privateLibrary().reset();
            ModContext.reset();
            ModEntityProfiles.setCustomProfiles(Collections.emptyMap());
            ModConfigSpec.COMMON.apply(null);
        });
        EventBus.register(ClientPlayerEvent.Clone.class, event -> SkinUtils.copySkinWardrobe((Entity)event.getOldPlayer(), (Entity)event.getNewPlayer()));
        EventBus.register(RenderFrameEvent.Pre.class, event -> {
            Scheduler.CLIENT.begin();
            AutoreleasePool.begin();
            TickUtils.tick(event.getDeltaTracker().isPaused() || event.getDeltaTracker().isFrozen());
            SkinPreloadManager.tick(event.getDeltaTracker().isPaused());
        });
        EventBus.register(RenderFrameEvent.Post.class, event -> {
            AutoreleasePool.end();
            Scheduler.CLIENT.end();
        });
        EventBus.register(RenderHighlightEvent.Block.class, event -> {
            PlayerEntity player = EnvironmentManager.getPlayer();
            if (player == null) {
                return;
            }
            IPoseStack poseStack = AbstractPoseStack.wrap(event.getPoseStack());
            AbstractBufferSource buffers = AbstractBufferSource.wrap(event.getMultiBufferSource());
            ItemStack itemStack = player.func_184614_ca();
            if (ModConfig.Client.enableEntityPlacementHighlight && Fix16.is(itemStack, (Item)ModItems.MANNEQUIN.get())) {
                HighlightPlacementRenderer.renderEntity(player, event.getTarget(), event.getCamera(), poseStack, buffers);
            }
            if (ModConfig.Client.enableBlockPlacementHighlight && Fix16.is(itemStack, (Item)ModItems.SKIN.get())) {
                HighlightPlacementRenderer.renderBlock(itemStack, player, event.getTarget(), event.getCamera(), poseStack, buffers);
            }
            if (ModConfig.Client.enablePaintToolPlacementHighlight && Fix16.is(itemStack, (Item)ModItems.BLENDING_TOOL.get())) {
                PaintingHighlightPlacementRenderer.renderPaintTool(itemStack, player, event.getTarget(), event.getCamera(), poseStack, buffers);
            }
        });
        EventBus.register(RenderLivingEntityEvent.Pre.class, event -> ClientWardrobeHandler.onRenderLivingEntityPre(event.getEntity(), event.getPartialTicks(), event.getPackedLight(), event.getPoseStack(), event.getMultiBufferSource(), event.getRenderer()));
        EventBus.register(RenderLivingEntityEvent.Setup.class, event -> ClientWardrobeHandler.onRenderLivingEntity(event.getEntity(), event.getPartialTicks(), event.getPackedLight(), event.getPoseStack(), event.getMultiBufferSource(), event.getRenderer()));
        EventBus.register(RenderLivingEntityEvent.Post.class, event -> ClientWardrobeHandler.onRenderLivingEntityPost(event.getEntity(), event.getPartialTicks(), event.getPackedLight(), event.getPoseStack(), event.getMultiBufferSource(), event.getRenderer()));
        EventBus.register(RenderSpecificHandEvent.class, event -> {
            if (!ModConfig.enableFirstPersonSkinRenderer()) {
                return;
            }
            OpenItemDisplayContext itemDisplayContext = OpenItemDisplayContext.FIRST_PERSON_LEFT_HAND;
            if (event.getHand() == Hand.MAIN_HAND) {
                itemDisplayContext = OpenItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
            }
            ClientWardrobeHandler.onRenderSpecificHand((LivingEntity)event.getPlayer(), 0.0f, event.getPackedLight(), itemDisplayContext, event.getPoseStack(), event.getMultiBufferSource(), () -> event.setCancelled(true));
        });
        EventBus.register(ItemTooltipEvent.Gather.class, ItemTooltipManager::gatherSkinTooltip);
        EventBus.register(ItemTooltipEvent.Render.class, ItemTooltipManager::renderSkinTooltip);
    }
}

