/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.data;

import java.util.ArrayList;
import java.util.Collection;
import moe.plushie.armourers_workshop.api.library.ISkinLibrary;
import moe.plushie.armourers_workshop.core.data.DataDomain;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinFile;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinFileHeader;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.FileUtils;

public class SkinLibraryFile
extends SkinFile
implements ISkinLibrary.Entry {
    private Collection<String> searchableContentList;

    public SkinLibraryFile(DataDomain domain, String name, String path) {
        super(domain, name, path, null, true, domain.equals((Object)DataDomain.DEDICATED_SERVER) && path.startsWith("/private"));
    }

    public SkinLibraryFile(DataDomain domain, String name, String path, SkinFileHeader header) {
        super(domain, name, FileUtils.normalize(path, true), header, false, false);
    }

    public boolean matches(String keywords, SkinType skinType) {
        if (skinType != SkinTypes.UNKNOWN && skinType != this.skinType()) {
            return false;
        }
        if (keywords != null && !keywords.isEmpty()) {
            return this.matchesInContentList(keywords);
        }
        return true;
    }

    public boolean isSameFile(SkinLibraryFile other) {
        return this.name.equals(other.name) && this.path.equals(other.path) && this.domain.equals((Object)other.domain);
    }

    private boolean matchesInContentList(String keyword) {
        int index = 0;
        int length = keyword.length();
        while (index < length) {
            int lastIndex = index;
            for (String content : this.searchableContentList()) {
                int searchIndex = -1;
                for (int offset = index; offset < length; ++offset) {
                    int ch = keyword.codePointAt(offset);
                    if (Character.isSpaceChar(ch)) {
                        index = offset + 1;
                        break;
                    }
                    if ((searchIndex = content.indexOf(ch, searchIndex + 1)) < 0) break;
                }
                if (searchIndex > 0) {
                    return true;
                }
                if (lastIndex == index) continue;
                break;
            }
            if (lastIndex != index) continue;
            return false;
        }
        return true;
    }

    private Collection<String> searchableContentList() {
        if (this.searchableContentList != null) {
            return this.searchableContentList;
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(FileUtils.removeExtension(this.path));
        SkinProperties properties = this.skinProperties();
        if (properties != null) {
            values.add(properties.get(SkinProperty.ALL_CUSTOM_NAME));
            values.add(properties.get(SkinProperty.ALL_AUTHOR_NAME));
            values.add(properties.get(SkinProperty.ALL_FLAVOUR_TEXT));
        }
        this.searchableContentList = Collections.compactMap(values, s -> {
            if (!s.isEmpty()) {
                return s.toLowerCase();
            }
            return null;
        });
        return this.searchableContentList;
    }
}

