/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import moe.plushie.armourers_workshop.api.library.ISkinLibraryListener;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinFileHeader;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinSerializer;
import moe.plushie.armourers_workshop.core.utils.FileUtils;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.library.data.SkinLibrary;
import moe.plushie.armourers_workshop.library.data.SkinLibraryFile;

public class SkinLibraryLoader
implements Runnable {
    private static final HashMap<String, CachedFileHeader> CACHED_FILE_HEADERS = new HashMap();
    private final File libraryDirectory = EnvironmentManager.getSkinLibraryDirectory();
    private final File basePath;
    private final SkinLibrary library;
    private final ISkinLibraryListener completeHandler;

    public SkinLibraryLoader(SkinLibrary library, File basePath, ISkinLibraryListener completeHandler) {
        this.basePath = basePath;
        this.library = library;
        this.completeHandler = completeHandler;
    }

    public ArrayList<SkinLibraryFile> getSkinFiles(File directory, boolean recursive) {
        File[] templateFiles;
        ArrayList<SkinLibraryFile> fileList = new ArrayList<SkinLibraryFile>();
        try {
            templateFiles = directory.listFiles();
            if (templateFiles == null) {
                return fileList;
            }
        }
        catch (Exception e) {
            ModLog.error("armour file list load failed.", new Object[0]);
            e.printStackTrace();
            return fileList;
        }
        for (File file : templateFiles) {
            String path = FileUtils.getRelativePath(file, this.libraryDirectory, true);
            String filename = file.getName();
            if (file.isDirectory()) {
                fileList.add(new SkinLibraryFile(this.library.domain, filename, path));
                continue;
            }
            if (!filename.toLowerCase().endsWith(".armour")) continue;
            String name = FileUtils.getBaseName(filename);
            SkinFileHeader header = this.getSkinFileHeader(file);
            if (header == null) continue;
            fileList.add(new SkinLibraryFile(this.library.domain, name, path, header));
        }
        Collections.sort(fileList);
        if (recursive) {
            for (File file : templateFiles) {
                if (!file.isDirectory()) continue;
                fileList.addAll(this.getSkinFiles(file, true));
            }
        }
        return fileList;
    }

    private SkinFileHeader getSkinFileHeader(File file) {
        SkinFileHeader skinFileHeader;
        String key = file.getAbsolutePath();
        CachedFileHeader cache = CACHED_FILE_HEADERS.get(key);
        long modifiedTime = FileUtils.getLastModifiedTime(file);
        if (cache != null && cache.isValid(modifiedTime)) {
            return cache.header();
        }
        FileInputStream inputStream = new FileInputStream(file);
        try {
            SkinFileHeader header = SkinSerializer.readHeaderFromStream(inputStream);
            if (header != null) {
                header.setLastModified((int)modifiedTime);
            }
            CACHED_FILE_HEADERS.put(key, new CachedFileHeader(modifiedTime, header));
            skinFileHeader = header;
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                return null;
            }
        }
        inputStream.close();
        return skinFileHeader;
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        ModLog.debug("loading skin library", new Object[0]);
        ArrayList<SkinLibraryFile> files = this.getSkinFiles(this.basePath, true);
        this.library.reloadFiles(files);
        this.library.endLoading();
        ModLog.debug(String.format("finished loading %d client library skins in %d ms", files.size(), System.currentTimeMillis() - startTime), new Object[0]);
        if (this.completeHandler != null) {
            this.completeHandler.libraryDidReload(null);
        }
    }

    public static class CachedFileHeader {
        private final long modifiedTime;
        private final SkinFileHeader header;

        public CachedFileHeader(long modifiedTime, SkinFileHeader header) {
            this.modifiedTime = modifiedTime;
            this.header = header;
        }

        public boolean isValid(long modifiedTime) {
            return this.modifiedTime == modifiedTime;
        }

        public SkinFileHeader header() {
            return this.header;
        }
    }
}

