/*
 * Decompiled with CFR 0.152.
 */
package me.drqonic.hakibar.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ClientConfig {
    public static final Path CONFIG_PATH = Paths.get("config", "hakibar-client.toml");
    public static final ClientConfig INSTANCE;
    public static final ForgeConfigSpec CONFIG;
    private ForgeConfigSpec.ConfigValue<Integer> containerHudX;
    private ForgeConfigSpec.ConfigValue<Integer> containerHudY;
    private ForgeConfigSpec.ConfigValue<Integer> fillHudX;
    private ForgeConfigSpec.ConfigValue<Integer> fillHudY;
    private ForgeConfigSpec.ConfigValue<Integer> overuseHudX;
    private ForgeConfigSpec.ConfigValue<Integer> overuseHudY;
    private ForgeConfigSpec.ConfigValue<AnchorPoint> anchorPoint;
    private Minecraft mc = Minecraft.func_71410_x();

    public ClientConfig(ForgeConfigSpec.Builder builder) {
        builder.push("General");
        this.containerHudX = builder.comment("The X coordinate for the container to display\nDefault: -60").define("Container Hud X", (Object)-60);
        this.containerHudY = builder.comment("The Y coordinate for the container bar to display\nDefault: 4").define("Container Hud Y", (Object)4);
        this.fillHudX = builder.comment("The X coordinate for the fill bar to display\nDefault: -57").define("Fill Hud X", (Object)-57);
        this.fillHudY = builder.comment("The Y coordinate for the fill bar to display\nDefault: 7").define("Fill Hud Y", (Object)7);
        this.overuseHudX = builder.comment("The X coordinate for the overuse to display\nDefault: 0").define("Overuse Hud X", (Object)0);
        this.overuseHudY = builder.comment("The Y coordinate for the overuse to display\nDefault: 16").define("Overuse Hud Y", (Object)16);
        this.anchorPoint = builder.comment("Position to anchor the widgets in\nOptions: TOP_LEFT, TOP_CENTER, TOP_RIGHT, BOTTOM_LEFT, BOTTOM_CENTER, BOTTOM_RIGHT\nDefault: TOP_CENTER").defineEnum("Anchor Point", (Enum)AnchorPoint.TOP_CENTER, (Enum[])AnchorPoint.values());
        builder.pop();
    }

    private int determineX(int x) {
        int screenWidth = this.mc.func_228018_at_().func_198107_o();
        switch ((AnchorPoint)((Object)this.anchorPoint.get())) {
            case TOP_CENTER: 
            case BOTTOM_CENTER: {
                return screenWidth / 2 + x;
            }
            case TOP_RIGHT: 
            case BOTTOM_RIGHT: {
                return screenWidth + x;
            }
        }
        return x;
    }

    private int determineY(int y) {
        int screenHeight = this.mc.func_228018_at_().func_198087_p();
        switch ((AnchorPoint)((Object)this.anchorPoint.get())) {
            case BOTTOM_CENTER: 
            case BOTTOM_RIGHT: 
            case BOTTOM_LEFT: {
                return screenHeight + y;
            }
        }
        return y;
    }

    public int getContainerHudX() {
        return this.determineX((Integer)this.containerHudX.get());
    }

    public int getContainerHudY() {
        return this.determineY((Integer)this.containerHudY.get());
    }

    public int getFillHudX() {
        return this.determineX((Integer)this.fillHudX.get());
    }

    public int getFillHudY() {
        return this.determineY((Integer)this.fillHudY.get());
    }

    public int getOveruseHudX() {
        return this.determineX((Integer)this.overuseHudX.get());
    }

    public int getOveruseHudY() {
        return this.determineY((Integer)this.overuseHudY.get());
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CONFIG = (ForgeConfigSpec)pair.getRight();
        INSTANCE = (ClientConfig)pair.getLeft();
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((Path)CONFIG_PATH).sync().autoreload().writingMode(WritingMode.REPLACE).build();
        file.load();
        file.save();
        CONFIG.setConfig((CommentedConfig)file);
    }

    private static enum AnchorPoint {
        TOP_LEFT,
        TOP_CENTER,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_CENTER,
        BOTTOM_RIGHT;

    }
}

