/*
 * Decompiled with CFR 0.152.
 */
package me.drqonic.hakibar.events;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import me.drqonic.hakibar.api.helpers.RendererHelper;
import me.drqonic.hakibar.config.ClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;

@Mod.EventBusSubscriber(modid="hakibar", value={Dist.CLIENT})
public class OverlayEvents {
    private static final ResourceLocation HAKI_CONTAINER_PATH = new ResourceLocation("hakibar", "textures/hud/container.png");
    private static final ResourceLocation HAKI_FILL_PATH = new ResourceLocation("hakibar", "textures/hud/fill.png");

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderGameOverlay(RenderGameOverlayEvent event) {
        MatrixStack mStack = event.getMatrixStack();
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        IEntityStats entityProps = EntityStatsCapability.get((LivingEntity)player);
        if (!entityProps.isInCombatMode()) {
            return;
        }
        if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        IHakiData hakiProps = HakiDataCapability.get((LivingEntity)player);
        Color clientRGB = new Color(HakiHelper.getHaoshokuColour((LivingEntity)player));
        int hakiOveruse = hakiProps.getHakiOveruse();
        int maxOveruse = hakiProps.getMaxOveruse();
        float hakiWidth = 114.0f / (float)maxOveruse * (float)(maxOveruse - hakiOveruse);
        RendererHelper.drawResource(HAKI_CONTAINER_PATH, mStack, ClientConfig.INSTANCE.getContainerHudX(), ClientConfig.INSTANCE.getContainerHudY(), 0, 120, 11);
        RendererHelper.drawResource(HAKI_FILL_PATH, mStack, ClientConfig.INSTANCE.getFillHudX(), ClientConfig.INSTANCE.getFillHudY(), 0, (int)hakiWidth, 5, (float)clientRGB.getRed() / 255.0f, (float)clientRGB.getGreen() / 255.0f, (float)clientRGB.getBlue() / 255.0f);
        AbstractGui.func_238471_a_((MatrixStack)mStack, (FontRenderer)mc.field_71466_p, (String)(maxOveruse - hakiOveruse + "/" + maxOveruse), (int)ClientConfig.INSTANCE.getOveruseHudX(), (int)ClientConfig.INSTANCE.getOveruseHudY(), (int)Color.WHITE.getRGB());
    }
}

