/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveAbility2;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModQuests;

public class EmptyHandsAbility
extends PassiveAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "empty_hands", new Pair[]{ImmutablePair.of((Object)"When active items picked from ground will never be put in the user's main hand.", null), ImmutablePair.of((Object)"If there's space in the inventory it will be put there, othewise it won't get picked up at all.", null)});
    public static final AbilityCore<EmptyHandsAbility> INSTANCE = new AbilityCore.Builder<EmptyHandsAbility>("Empty Hands", AbilityCategory.STYLE, AbilityType.PASSIVE, EmptyHandsAbility::new).addDescriptionLine(DESCRIPTION).setUnlockCheck(EmptyHandsAbility::canUnlock).build();

    public EmptyHandsAbility(AbilityCore<EmptyHandsAbility> core) {
        super(core);
        this.addEquipEvent(this::onEquipEvent);
    }

    private void onEquipEvent(LivingEntity entity, IAbility ability) {
        if (entity != null && !entity.field_70170_p.field_72995_K) {
            this.pauseTickComponent.setPause(entity, true);
        }
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IQuestData questProps = QuestDataCapability.get(player);
        return questProps.hasFinishedQuest(ModQuests.EMPTY_HANDS_TRIAL);
    }
}

