/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import java.io.Serializable;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.SourceImmunityAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiEmissionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.config.AbilitiesConfig;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class LogiaInvulnerabilityAbility
extends SourceImmunityAbility {
    public static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "logia_invulnerability", new Pair[]{ImmutablePair.of((Object)"Allows the user to avoid attacks by instinctively transforming parts of their body into their specific element", null)});
    private static final TranslationTextComponent LOGIA_INVULN_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.logia_invulnerability", "Logia Invulnerability"));
    private Supplier<ParticleEffect<?>> particleEffect;
    public ILogiaReturnEffect onLogiaEffect = (target, attacker) -> true;

    public LogiaInvulnerabilityAbility(AbilityCore core, @Nullable SourceImmunityAbility.SourceImmunityInfo immunityInfo, Supplier<ParticleEffect<?>> particleEffect) {
        super(core, immunityInfo);
        this.particleEffect = particleEffect;
        this.setDisplayName((ITextComponent)LOGIA_INVULN_NAME);
    }

    @Override
    public boolean isDamageTaken(LivingEntity entity, DamageSource source, float amount) {
        LivingEntity attacker;
        if (source instanceof AbilityDamageSource && ((AbilityDamageSource)source).getAbilitySource().equals(super.getCore())) {
            return false;
        }
        Entity directEntity = source.func_76364_f();
        if (directEntity != null && directEntity instanceof LivingEntity && (attacker = (LivingEntity)directEntity).func_184586_b(attacker.func_184600_cs()).func_190926_b()) {
            boolean hasEmissionActive;
            BusoshokuHakiEmissionAbility emissionHaki = AbilityDataCapability.get(attacker).getEquippedAbility(BusoshokuHakiEmissionAbility.INSTANCE);
            boolean bl = hasEmissionActive = emissionHaki != null && emissionHaki.isContinuous();
            if (CommonConfig.INSTANCE.isLogiaDamageEffectEnabled() && !hasEmissionActive) {
                this.onLogiaEffect.returnEffect(entity, attacker);
            }
        }
        if (!((Boolean)AbilitiesConfig.LOGIA_INVULNERABILITY.get()).booleanValue() || source instanceof ModDamageSource && ((ModDamageSource)source).isBypassingLogia()) {
            return true;
        }
        if (DevilFruitCapability.get(entity).hasYamiPower()) {
            return true;
        }
        if (source instanceof AbilityDamageSource && ((AbilityDamageSource)source).getElement() == SourceElement.SHOCKWAVE) {
            return true;
        }
        if (directEntity != null) {
            boolean hasImbuingActive;
            Entity projectileOwner;
            LivingEntity sourceOwner = null;
            if (directEntity instanceof LivingEntity) {
                sourceOwner = (LivingEntity)directEntity;
            } else if (directEntity instanceof AbilityProjectileEntity) {
                sourceOwner = ((AbilityProjectileEntity)directEntity).getThrower();
            } else if (directEntity instanceof ProjectileEntity && (projectileOwner = ((ProjectileEntity)directEntity).func_234616_v_()) != null && projectileOwner instanceof LivingEntity) {
                sourceOwner = (LivingEntity)projectileOwner;
                hasImbuingActive = HakiHelper.hasImbuingActive((LivingEntity)projectileOwner);
                if (hasImbuingActive) {
                    return true;
                }
                this.spawnParticles(entity);
                return false;
            }
            if (sourceOwner != null) {
                boolean isBlocking = AbilityHelper.isLogiaBlocking((Entity)sourceOwner, entity);
                if (!isBlocking) {
                    return true;
                }
                hasImbuingActive = HakiHelper.hasImbuingActive(sourceOwner);
                boolean hasHardeningActive = HakiHelper.hasHardeningActive(sourceOwner);
                boolean isImmune = true;
                if (source instanceof ModDamageSource) {
                    ModDamageSource mSource = (ModDamageSource)source;
                    if (mSource.getHakiNature() == SourceHakiNature.IMBUING && hasImbuingActive) {
                        isImmune = false;
                    } else if (mSource.getHakiNature() == SourceHakiNature.HARDENING && hasHardeningActive) {
                        isImmune = false;
                    } else if (mSource.getHakiNature() == SourceHakiNature.SPECIAL && (hasImbuingActive || hasHardeningActive)) {
                        isImmune = false;
                    }
                } else if (source instanceof EntityDamageSource) {
                    isImmune = !hasHardeningActive;
                } else if (source instanceof IndirectEntityDamageSource) {
                    boolean bl = isImmune = !hasImbuingActive;
                }
                if (isImmune) {
                    this.spawnParticles(entity);
                    return false;
                }
                return true;
            }
        }
        boolean hasShadow = EntityStatsCapability.get(entity).hasShadow();
        if (this.immunityInfo.isImmune(DamageSource.field_76370_b) && source.func_76347_k() && !hasShadow) {
            return true;
        }
        if (source.func_94541_c()) {
            this.spawnParticles(entity);
            return false;
        }
        boolean isImmune = this.immunityInfo.isImmune(source);
        boolean fireResistance = this.immunityInfo.isImmune(DamageSource.field_76370_b);
        if (source.field_76373_n.equalsIgnoreCase(DamageSource.field_76370_b.field_76373_n) && fireResistance && hasShadow) {
            entity.func_70066_B();
            this.spawnParticles(entity);
            return false;
        }
        if (isImmune) {
            this.spawnParticles(entity);
            return false;
        }
        return true;
    }

    public void spawnParticles(LivingEntity entity) {
        WyHelper.spawnParticleEffect(this.particleEffect.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
    }

    public static interface ILogiaReturnEffect
    extends Serializable {
        public boolean returnEffect(LivingEntity var1, LivingEntity var2);
    }
}

