/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.api.IPlayerAbilities;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.GaugeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public abstract class PropelledFlightAbility
extends PassiveAbility2 {
    protected boolean isRecovering = false;
    protected boolean hasLanded = false;
    protected double stamina = 100.0;
    protected float speed = 0.0f;
    private Vector3d oldMovement = Vector3d.field_186680_a;
    private Interval staminaInterval = new Interval(20);
    private static final ResourceLocation SPECIAL_FLY_ICON = new ResourceLocation("mineminenomi", "textures/abilities/special_fly.png");

    public PropelledFlightAbility(AbilityCore<? extends PropelledFlightAbility> core) {
        super(core);
        super.setDisplayIcon(SPECIAL_FLY_ICON);
        if (super.isClientSide()) {
            GaugeComponent gaugeComponent = new GaugeComponent(this, this::renderGauge);
            super.addComponents(gaugeComponent);
        }
        this.addRemoveEvent(this::onRemove);
        this.pauseTickComponent.addResumeEvent(100, this::onResume).addPauseEvent(100, this::onPause);
        super.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        super.addDuringPassiveEvent(this::onDuringPassive);
    }

    @Override
    public void tick(LivingEntity entity) {
        super.tick(entity);
        if (!(entity instanceof PlayerEntity) || this.pauseTickComponent.isPaused()) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        if (!AbilityHelper.canUseMomentumAbilities((LivingEntity)player)) {
            player.field_71075_bZ.field_75100_b = false;
        }
        float health = player.func_110143_aJ();
        float maxHealth = player.func_110138_aP();
        if (this.stamina <= 0.0) {
            this.isRecovering = true;
        }
        if (player.func_233570_aj_() && this.stamina < 100.0 && this.staminaInterval.canTick()) {
            this.alterStamina((double)(health / maxHealth) * 2.5);
        }
        if (this.isRecovering && this.stamina >= 100.0) {
            this.isRecovering = false;
            this.hasLanded = false;
            PropelledFlightAbility.enableFlight(player);
        }
    }

    private void onRemove(LivingEntity entity, PassiveAbility2 ability) {
        if (entity instanceof PlayerEntity) {
            PropelledFlightAbility.disableFlight((PlayerEntity)entity);
        }
    }

    private void onResume(LivingEntity entity, IAbility ability) {
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        if (super.canUse(entity).isSuccess()) {
            PropelledFlightAbility.enableFlight(player);
        }
    }

    private void onDuringPassive(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        if (this.isRecovering) {
            if (!this.hasLanded && !entity.field_70170_p.func_175623_d(entity.func_233580_cy_().func_177979_c(5))) {
                this.hasLanded = true;
            }
            if (this.hasLanded) {
                PropelledFlightAbility.disableFlight(player);
                return;
            }
        }
        float health = player.func_110143_aJ();
        float maxHealth = player.func_110138_aP();
        if (!this.isRecovering && this.stamina > 0.0 && player.field_71075_bZ.field_75100_b && health < maxHealth && this.staminaInterval.canTick()) {
            this.alterStamina((double)((maxHealth - health) / maxHealth) * -5.0);
        }
        if (AbilityHelper.isInCreativeOrSpectator(entity)) {
            if (((IPlayerAbilities)player.field_71075_bZ).hasCustomFlight()) {
                PropelledFlightAbility.disableFlight(player);
            }
            return;
        }
        if (!((IPlayerAbilities)player.field_71075_bZ).hasCustomFlight()) {
            PropelledFlightAbility.enableFlight(player);
        }
        if (!player.field_71075_bZ.field_75100_b || !AbilityHelper.canUseMomentumAbilities((LivingEntity)player) || super.canUse((LivingEntity)player).isFail()) {
            this.speed = 0.0f;
            return;
        }
        boolean isFlying = this.isFlying((LivingEntity)player);
        float maxSpeed = this.getMaxSpeed((LivingEntity)player);
        float acceleration = this.getAcceleration((LivingEntity)player);
        acceleration = isFlying ? (acceleration *= this.speed > 0.0f ? 1.0f - this.speed / maxSpeed : 1.0f) : -maxSpeed / 20.0f;
        this.speed = MathHelper.func_76131_a((float)(this.speed + acceleration), (float)(acceleration > 0.0f ? maxSpeed / 5.0f : 0.0f), (float)maxSpeed);
        this.speed = this.getSpeed((LivingEntity)player);
        BlockPos belowPos = player.func_226270_aj_();
        float slipperiness = player.field_70170_p.func_180495_p(belowPos).getSlipperiness((IWorldReader)player.field_70170_p, belowPos, (Entity)player);
        float friction = player.func_233570_aj_() ? slipperiness * 0.91f : 0.91f;
        friction = !player.field_70123_F ? friction : 0.0f;
        Vector3d movementVec = this.getMovementVector(entity);
        Vector3d flightMovement = new Vector3d(movementVec.field_72450_a, this.isRecovering ? -0.5 : movementVec.field_72448_b, movementVec.field_72449_c);
        Vector3d movementDiff = flightMovement.func_178788_d(this.oldMovement.func_216372_d((double)friction, 0.6, (double)friction));
        Vector3d currentMovement = player.func_213322_ci();
        Vector3d newMovement = currentMovement.func_178787_e(movementDiff);
        this.oldMovement = flightMovement;
        AbilityHelper.setDeltaMovement((Entity)player, newMovement);
        if (!CommonConfig.INSTANCE.hasYRestrictionRemoved() && !DevilFruitHelper.flyingAtMaxHeight((LivingEntity)player, this.getHeightDifference((LivingEntity)player))) {
            AbilityHelper.setDeltaMovement((Entity)player, 0.0, -1.0, 0.0);
        }
        player.field_70143_R = 0.0f;
    }

    private void onPause(LivingEntity entity, IAbility ability) {
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        PropelledFlightAbility.disableFlight(player);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderGauge(PlayerEntity player, MatrixStack matrixStack, int posX, int posY, IAbility ability) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(ModResources.WIDGETS);
        RendererHelper.drawIcon(SPECIAL_FLY_ICON, matrixStack, posX, posY - 38, 0.0f, 32.0f, 32.0f);
        DecimalFormat staminaFormat = new DecimalFormat("#0.0");
        String strStamina = staminaFormat.format(this.stamina);
        WyHelper.drawStringWithBorder(mc.field_71466_p, matrixStack, strStamina, posX + 15 - mc.field_71466_p.func_78256_a(strStamina) / 2, posY - 25, Color.WHITE.getRGB());
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        nbt = super.save(nbt);
        nbt.func_74757_a("isRecovering", this.isRecovering);
        nbt.func_74757_a("hasLanded", this.hasLanded);
        nbt.func_74780_a("stamina", this.stamina);
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt) {
        super.load(nbt);
        this.isRecovering = nbt.func_74767_n("isRecovering");
        this.hasLanded = nbt.func_74767_n("hasLanded");
        this.stamina = nbt.func_74769_h("stamina");
    }

    public double getStamina() {
        return this.stamina;
    }

    public void alterStamina(double stamina) {
        this.stamina = MathHelper.func_151237_a((double)(this.stamina + stamina), (double)0.0, (double)100.0);
    }

    public boolean isFlying(LivingEntity entity) {
        boolean isMovingAboveGround;
        boolean bl = isMovingAboveGround = (entity.field_191988_bg != 0.0f || entity.field_70702_br != 0.0f) && !entity.field_70124_G && !entity.field_70123_F;
        if (entity instanceof PlayerEntity) {
            return ((PlayerEntity)entity).field_71075_bZ.field_75100_b && isMovingAboveGround;
        }
        return isMovingAboveGround;
    }

    public float getSpeed(LivingEntity entity) {
        return this.speed;
    }

    protected Vector3d getMovementVector(LivingEntity entity) {
        Vector3d lookVector = entity.func_70040_Z();
        double x = lookVector.field_72450_a * (double)this.speed * (double)entity.field_191988_bg;
        double y = lookVector.field_72448_b * (double)this.speed * (double)entity.field_191988_bg + Math.cos((double)entity.field_70173_aa / 4.0) / 15.0;
        double z = lookVector.field_72449_c * (double)this.speed * (double)entity.field_191988_bg;
        return new Vector3d(x, y, z);
    }

    public abstract float getMaxSpeed(LivingEntity var1);

    protected abstract float getAcceleration(LivingEntity var1);

    protected abstract int getHeightDifference(LivingEntity var1);

    public static void enableFlight(PlayerEntity player) {
        if (AbilityHelper.isInCreativeOrSpectator((LivingEntity)player)) {
            return;
        }
        ((IPlayerAbilities)player.field_71075_bZ).setCustomFlight(true);
        player.field_71075_bZ.field_75101_c = true;
        if (!player.field_70170_p.field_72995_K) {
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
        }
    }

    public static void disableFlight(PlayerEntity player) {
        if (!AbilityHelper.isInCreativeOrSpectator((LivingEntity)player)) {
            player.field_71075_bZ.field_75101_c = false;
            player.field_71075_bZ.field_75100_b = false;
        }
        ((IPlayerAbilities)player.field_71075_bZ).setCustomFlight(false);
        if (!player.field_70170_p.field_72995_K) {
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
        }
    }
}

