/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.DropHitAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.BreakingBlocksParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SlamAbility
extends DropHitAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "slam", new Pair[]{ImmutablePair.of((Object)"The user jumps in the air and uses their fists or weapon to smash the target and the ground around it.", null)});
    private static final float COOLDOWN = 240.0f;
    private static final float RANGE = 2.0f;
    private static final float DAMAGE = 20.0f;
    public static final TargetsPredicate TARGET_TEST = new TargetsPredicate().testEnemyFaction().testSimpleInView();
    public static final AbilityCore<SlamAbility> INSTANCE = new AbilityCore.Builder<SlamAbility>("Slam", AbilityCategory.STYLE, SlamAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(240.0f), RangeComponent.getTooltip(2.0f, RangeComponent.RangeType.AOE), DealDamageComponent.getTooltip(20.0f)).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(SourceType.BLUNT).build();
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private BreakingBlocksParticleEffect.Details details = new BreakingBlocksParticleEffect.Details(40);

    public SlamAbility(AbilityCore<SlamAbility> core) {
        super((AbilityCore<? extends DropHitAbility2>)core);
        this.addComponents(this.dealDamageComponent, this.rangeComponent, this.animationComponent);
        this.continuousComponent.addStartEvent(100, this::startContinuityEvent);
        this.continuousComponent.addEndEvent(100, this::endContinuityEvent);
        this.continuousComponent.addTickEvent(100, this::tickContinuityEvent);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        Vector3d speed = entity.func_70040_Z();
        AbilityHelper.setDeltaMovement((Entity)entity, speed.field_72450_a, 1.5, speed.field_72449_c);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70143_R > 0.0f && !this.hasLanded()) {
            this.animationComponent.start(entity, ModAnimations.WEAPON_SLAM);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 240.0f);
    }

    @Override
    public void onLanding(LivingEntity entity) {
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 2.0f, TARGET_TEST);
        for (LivingEntity target : targets) {
            if (!this.hitTrackerComponent.canHit((Entity)target) || !this.dealDamageComponent.hurtTarget(entity, target, 20.0f)) continue;
            target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 40, 0, false, false));
        }
        ArrayList<Vector3d> positions = new ArrayList<Vector3d>();
        int range = (int)Math.ceil(this.rangeComponent.getRange());
        for (int x = -range; x < range; ++x) {
            for (int z = -range; z < range; ++z) {
                double posX = entity.func_226277_ct_() + (double)x;
                double posY = entity.func_226278_cu_() - 1.0;
                double posZ = entity.func_226281_cx_() + (double)z;
                Vector3d pos = new Vector3d(posX, posY, posZ);
                positions.add(pos);
            }
        }
        if (positions.size() > 0) {
            this.details.setVecPositions(positions);
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.BREAKING_BLOCKS.get(), (Entity)entity, 0.0, 0.0, 0.0, this.details);
        }
        this.continuousComponent.stopContinuity(entity);
    }
}

