/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;

public class SlashDamageImmunityAbility
extends PassiveAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "slash_damage_immunity", new Pair[]{ImmutablePair.of((Object)"Makes the user immune to slash based attacks", null)});
    public static final AbilityCore<SlashDamageImmunityAbility> BARA_INSTANCE = new AbilityCore.Builder<SlashDamageImmunityAbility>("Slash Damage Immunity", AbilityCategory.DEVIL_FRUITS, AbilityType.PASSIVE, SlashDamageImmunityAbility::new).addDescriptionLine(DESCRIPTION).setHidden().build();
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this).addOnAttackEvent(this::onDamageTaken);

    public SlashDamageImmunityAbility(AbilityCore<SlashDamageImmunityAbility> ability) {
        super(ability);
        this.addComponents(this.damageTakenComponent);
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        Entity entitySource;
        boolean isSlashDamage = damageSource instanceof ModDamageSource && ((ModDamageSource)damageSource).isSlash();
        boolean isSwordDamage = false;
        if ((damageSource instanceof EntityDamageSource || damageSource instanceof AbilityDamageSource) && (entitySource = damageSource.func_76346_g()) != null && entitySource.func_70089_S() && entitySource instanceof LivingEntity) {
            LivingEntity livingSource = (LivingEntity)entitySource;
            boolean bl = isSwordDamage = this.checkItemStack(livingSource.func_184614_ca()) || this.checkItemStack(livingSource.func_184592_cb());
        }
        if (isSlashDamage || isSwordDamage) {
            return 0.0f;
        }
        return damage;
    }

    private boolean checkItemStack(ItemStack stack) {
        if (stack != null && !stack.func_190926_b()) {
            boolean hasDamageAttribute;
            boolean isSword = ItemsHelper.isSword(stack);
            boolean bl = hasDamageAttribute = stack.func_111283_C(EquipmentSlotType.MAINHAND).get((Object)Attributes.field_233823_f_).size() > 0;
            if (isSword || hasDamageAttribute) {
                return true;
            }
        }
        return false;
    }
}

