/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.artofweather;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.ArtOfWeatherHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.artofweather.GustSwordProjectile;
import xyz.pixelatedw.mineminenomi.init.ModQuests;

public class GustSwordAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "gust_sword", new Pair[]{ImmutablePair.of((Object)"Fires a concentrated wind blast forward, knocking back all enemies that it comes in contact with", null)});
    private static final float COOLDOWN = 10.0f;
    public static final AbilityCore<GustSwordAbility> INSTANCE = new AbilityCore.Builder<GustSwordAbility>("Gust Sword", AbilityCategory.STYLE, GustSwordAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(10.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.AIR).setSourceHakiNature(SourceHakiNature.IMBUING).setUnlockCheck(GustSwordAbility::canUnlock).build();
    private final RepeaterComponent repeaterComponent = new RepeaterComponent(this).addTriggerEvent(this::triggerRepeaterEvent).addStopEvent(this::endRepeaterEvent);
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(100, this::startContinuousEvent).addEndEvent(100, this::endContinuousEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);

    public GustSwordAbility(AbilityCore<GustSwordAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.repeaterComponent, this.projectileComponent, this.continuousComponent);
        this.addCanUseCheck(ArtOfWeatherHelper::needsSorceryClimaTact);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void startContinuousEvent(LivingEntity entity, IAbility ability) {
        this.repeaterComponent.start(entity, 6, 3);
    }

    private void endContinuousEvent(LivingEntity entity, IAbility ability) {
        this.repeaterComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 10.0f);
    }

    private void triggerRepeaterEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 2.0f, 3.0f);
    }

    private void endRepeaterEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
    }

    private GustSwordProjectile createProjectile(LivingEntity entity) {
        GustSwordProjectile proj = new GustSwordProjectile(entity.field_70170_p, entity);
        return proj;
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isWeatherWizard() && questProps.hasFinishedQuest(ModQuests.ART_OF_WEATHER_TRIAL_04);
    }
}

