/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.bane;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.bane.SpringDeathKnockProjectile;

public class SpringDeathKnockAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "spring_death_knock", new Pair[]{ImmutablePair.of((Object)"By turning the user's arm into a spring and compressing it, they can launch a powerful punch", null)});
    private static final int COOLDOWN = 80;
    public static final AbilityCore<SpringDeathKnockAbility> INSTANCE = new AbilityCore.Builder<SpringDeathKnockAbility>("Spring Death Knock", AbilityCategory.DEVIL_FRUITS, SpringDeathKnockAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(CooldownComponent.getTooltip(80.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);

    public SpringDeathKnockAbility(AbilityCore<SpringDeathKnockAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.projectileComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 3.0f, 1.0f);
        this.cooldownComponent.startCooldown(entity, 80.0f);
        entity.func_226292_a_(Hand.MAIN_HAND, true);
    }

    private SpringDeathKnockProjectile createProjectile(LivingEntity entity) {
        SpringDeathKnockProjectile proj = new SpringDeathKnockProjectile(entity.field_70170_p, entity, this);
        return proj;
    }
}

