/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.bane;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SpringHopperAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "spring_hopper", new Pair[]{ImmutablePair.of((Object)"By turning the entity's legs into springs, they can jump around with great ease bouncing around surfaces", null)});
    private static final UUID SPRING_POWER_UUID = UUID.fromString("a44a9644-369a-4e18-88d9-323727d3d85b");
    private static final int COOLDOWN = 200;
    public static final AbilityCore<SpringHopperAbility> INSTANCE = new AbilityCore.Builder<SpringHopperAbility>("Spring Hopper", AbilityCategory.DEVIL_FRUITS, SpringHopperAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), ContinuousComponent.getTooltip()).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::onContinuityStart).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final MorphComponent morphComponent = new MorphComponent(this);
    private final ChangeStatsComponent changeStatsComponent = new ChangeStatsComponent(this);
    private int jumpPower = 0;
    private boolean canIncreaseJumpPower = false;
    private boolean startedFalling = false;

    public SpringHopperAbility(AbilityCore<SpringHopperAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.continuousComponent, this.morphComponent, this.changeStatsComponent);
        super.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    public void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.morphComponent.startMorph(entity, (MorphInfo)ModMorphs.SPRING_LEGS.get());
    }

    public void onContinuityTick(LivingEntity entity, IAbility ability) {
        Vector3d speed;
        if (this.canUse(entity).isFail()) {
            this.jumpPower = 0;
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        if (entity.field_70123_F && this.jumpPower > 2) {
            speed = entity.func_70040_Z().func_216372_d(-2.0, -2.0, -2.0);
            AbilityHelper.setDeltaMovement((Entity)entity, speed.field_72450_a, speed.field_72448_b, speed.field_72449_c);
            if (this.jumpPower < 9) {
                ++this.jumpPower;
            }
            if (entity instanceof PlayerEntity) {
                entity.field_70170_p.func_184133_a((PlayerEntity)entity, entity.func_233580_cy_(), (SoundEvent)ModSounds.SPRING_SFX.get(), SoundCategory.PLAYERS, 1.0f, (float)MathHelper.func_151237_a((double)(entity.func_70681_au().nextDouble() + (double)0.3f), (double)0.5, (double)1.5));
            }
        }
        if (entity.func_233570_aj_()) {
            this.startedFalling = true;
            if (AbilityHelper.isJumping(entity)) {
                if (this.jumpPower > 3) {
                    speed = WyHelper.propulsion(entity, 0.25 + (double)this.jumpPower * 0.25, 0.25 + (double)this.jumpPower * 0.25);
                    AbilityHelper.setDeltaMovement((Entity)entity, speed.field_72450_a, entity.func_213322_ci().field_72448_b, speed.field_72449_c);
                }
                if (this.jumpPower < 9 && this.canIncreaseJumpPower) {
                    ++this.jumpPower;
                }
                if (entity.func_110148_a((Attribute)ModAttributes.JUMP_HEIGHT.get()).func_111126_e() != (double)this.jumpPower * 1.5) {
                    this.changeStatsComponent.removeModifiers(entity);
                    this.changeStatsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.JUMP_HEIGHT, this.getJumpHeight(this.jumpPower), e -> this.continuousComponent.isContinuous());
                }
                if (entity instanceof PlayerEntity) {
                    entity.field_70170_p.func_184133_a((PlayerEntity)entity, entity.func_233580_cy_(), (SoundEvent)ModSounds.SPRING_SFX.get(), SoundCategory.PLAYERS, 0.3f, (float)MathHelper.func_151237_a((double)(entity.func_70681_au().nextDouble() + (double)0.3f), (double)0.8f, (double)1.5));
                }
                this.canIncreaseJumpPower = true;
            } else {
                this.jumpPower = 0;
            }
        } else {
            if (entity.field_70124_G) {
                --this.jumpPower;
            }
            if (0.0 > entity.func_213322_ci().field_72448_b) {
                if (this.startedFalling) {
                    this.canIncreaseJumpPower = DevilFruitHelper.getDifferenceToFloor((Entity)entity) > (double)this.jumpPower;
                    this.startedFalling = false;
                }
                if (this.jumpPower > 3) {
                    AbilityHelper.setDeltaMovement((Entity)entity, entity.func_213322_ci().func_186678_a(1.15));
                }
            }
        }
    }

    public void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.morphComponent.stopMorph(entity);
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }

    public AttributeModifier getJumpHeight(int jumpPower) {
        return new AbilityAttributeModifier(SPRING_POWER_UUID, INSTANCE, "Spring Movement Modifier", (double)jumpPower * 1.5, AttributeModifier.Operation.MULTIPLY_BASE);
    }
}

