/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.bari;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BarrierBallAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "barrier_ball", new Pair[]{ImmutablePair.of((Object)"The user creates a spherical barrier where they're pointing.", null)});
    private static final int HOLD_TIME = 300;
    private static final int COOLDOWN = 200;
    public static final AbilityCore<BarrierBallAbility> INSTANCE = new AbilityCore.Builder<BarrierBallAbility>("Barrier Ball", AbilityCategory.DEVIL_FRUITS, BarrierBallAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), ContinuousComponent.getTooltip(300.0f)).build();
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(AirBlockProtectionRule.INSTANCE).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::startContinuityEvent).addEndEvent(this::endContinuityEvent);
    private List<BlockPos> posList = new ArrayList<BlockPos>();

    public BarrierBallAbility(AbilityCore<BarrierBallAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 300.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.posList.isEmpty()) {
            RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, 64.0);
            World world = entity.field_70170_p;
            if (mop != null) {
                this.posList.addAll(AbilityHelper.createEmptySphere(world, (int)mop.func_216347_e().field_72450_a, (int)mop.func_216347_e().field_72448_b, (int)mop.func_216347_e().field_72449_c, 5, (Block)ModBlocks.BARRIER.get(), GRIEF_RULE));
                this.posList.addAll(AbilityHelper.createEmptySphere(world, (int)mop.func_216347_e().field_72450_a, (int)mop.func_216347_e().field_72448_b, (int)mop.func_216347_e().field_72449_c, 6, (Block)ModBlocks.BARRIER.get(), GRIEF_RULE));
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        for (BlockPos pos : this.posList) {
            if (entity.field_70170_p.func_180495_p(pos).func_177230_c() != ModBlocks.BARRIER.get()) continue;
            entity.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        this.posList.clear();
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }
}

