/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.blackleg;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.DiableJambeAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class PartyTableKickCourseAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "party_table_kick_course", new Pair[]{ImmutablePair.of((Object)"The user does a hand stand on the ground, legs spread out spinning and dealing damage to all nearby enemies", null)});
    private static final float COOLDOWN = 240.0f;
    private static final float RANGE = 2.5f;
    private static final float DAMAGE = 25.0f;
    public static final AbilityCore<PartyTableKickCourseAbility> INSTANCE = new AbilityCore.Builder<PartyTableKickCourseAbility>("Party-Table Kick Course", AbilityCategory.STYLE, PartyTableKickCourseAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(240.0f), DealDamageComponent.getTooltip(25.0f), RangeComponent.getTooltip(2.5f, RangeComponent.RangeType.AOE)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).setUnlockCheck(PartyTableKickCourseAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::onStartContinuityEvent).addEndEvent(this::onStopContinuityEvent).addTickEvent(this::duringContinuityEvent);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);

    public PartyTableKickCourseAbility(AbilityCore<PartyTableKickCourseAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.animationComponent, this.dealDamageComponent, this.rangeComponent);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 20.0f);
    }

    private boolean onStartContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.HAND_STAND_SPIN);
        return true;
    }

    private boolean onStopContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 240.0f);
        return true;
    }

    private boolean duringContinuityEvent(LivingEntity entity, IAbility ability) {
        DiableJambeAbility diableJambeAbility;
        boolean isAbilityEnabled;
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 1));
        List<LivingEntity> list = this.rangeComponent.getTargetsInArea(entity, 2.5f);
        for (LivingEntity target : list) {
            if (!this.dealDamageComponent.hurtTarget(entity, target, 25.0f)) continue;
            Vector3d speed = WyHelper.propulsion(entity, 1.5, 1.5);
            AbilityHelper.setDeltaMovement((Entity)target, speed.field_72450_a, 1.5, speed.field_72449_c);
        }
        if (!entity.field_70170_p.field_72995_K && list.size() > 0) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
        }
        boolean bl = isAbilityEnabled = (diableJambeAbility = AbilityDataCapability.get(entity).getEquippedAbility(DiableJambeAbility.INSTANCE)) != null && diableJambeAbility.isContinuous();
        if (isAbilityEnabled) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.PARTY_TABLE_KICK.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        }
        return true;
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isBlackLeg() && questProps.hasFinishedQuest(ModQuests.BLACK_LEG_TRIAL_03);
    }
}

