/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.bomu;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.bomu.BreezeBreathBombProjectile;

public class BreezeBreathBombAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "breeze_breath_bomb", new Pair[]{ImmutablePair.of((Object)"Load a gun with explosive breath and shoot a chain explosion", null)});
    private static final float COOLDOWN = 300.0f;
    public static final AbilityCore<BreezeBreathBombAbility> INSTANCE = new AbilityCore.Builder<BreezeBreathBombAbility>("Breeze Breath Bomb", AbilityCategory.DEVIL_FRUITS, BreezeBreathBombAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(300.0f), ContinuousComponent.getTooltip()).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(SourceType.BULLET).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addEndEvent(100, this::endContinuityEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile).addAfterShootEvent(100, this::afterShootEvent);

    public BreezeBreathBombAbility(AbilityCore<BreezeBreathBombAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.projectileComponent);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }

    private void afterShootEvent(LivingEntity entity) {
        this.continuousComponent.stopContinuity(entity);
    }

    public BreezeBreathBombProjectile createProjectile(LivingEntity entity) {
        BreezeBreathBombProjectile proj = new BreezeBreathBombProjectile(entity.field_70170_p, entity);
        return proj;
    }
}

