/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.bomu;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.bomu.NoseFancyCannonProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;

public class NoseFancyCannonAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "nose_fancy_cannon", new Pair[]{ImmutablePair.of((Object)"Shoots dried mucus at the opponent, which explodes on impact", null)});
    private static final float COOLDOWN = 80.0f;
    private static final int ANIMATION_TICKS = 7;
    public static final AbilityCore<NoseFancyCannonAbility> INSTANCE = new AbilityCore.Builder<NoseFancyCannonAbility>("Nose Fancy Cannon", AbilityCategory.DEVIL_FRUITS, NoseFancyCannonAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(80.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceElement(SourceElement.EXPLOSION).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final AnimationComponent animationComponent = new AnimationComponent(this);

    public NoseFancyCannonAbility(AbilityCore<NoseFancyCannonAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.projectileComponent, this.animationComponent);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 2.0f, 1.0f);
        this.cooldownComponent.startCooldown(entity, 80.0f);
        this.animationComponent.start(entity, ModAnimations.AIM_SNIPER, 7);
    }

    private NoseFancyCannonProjectile createProjectile(LivingEntity entity) {
        NoseFancyCannonProjectile proj = new NoseFancyCannonProjectile(entity.field_70170_p, entity, this);
        return proj;
    }
}

