/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.brawler;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.GrabEntityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;

public class RyuNoKagizumeAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "ryu_no_kagizume", new Pair[]{ImmutablePair.of((Object)"The user attacks the enemy with a three-fingered claw hand strike, targeting their weak points to deal heavy damage and damaging their armour.", null)});
    private static final int COOLDOWN = 400;
    private static final int CHARGE_TIME = 20;
    private static final int DAMAGE = 50;
    public static final AbilityCore<RyuNoKagizumeAbility> INSTANCE = new AbilityCore.Builder<RyuNoKagizumeAbility>("Ryu no Kagizume", AbilityCategory.STYLE, RyuNoKagizumeAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(400.0f), ChargeComponent.getTooltip(20.0f), DealDamageComponent.getTooltip(50.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).setUnlockCheck(RyuNoKagizumeAbility::canUnlock).build();
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addEndEvent(this::onContinuityEnd);
    private final GrabEntityComponent grabComponent = new GrabEntityComponent(this, true, false, 1.0f);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent(this).addOnHitEvent(this::onHitEvent);
    private final PoolComponent poolComponent = new PoolComponent(this, ModAbilityPools.GRAB_ABILITY, new AbilityPool2[0]);

    public RyuNoKagizumeAbility(AbilityCore<RyuNoKagizumeAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.chargeComponent, this.animationComponent, this.dealDamageComponent, this.continuousComponent, this.grabComponent, this.hitTriggerComponent, this.poolComponent);
        super.addCanUseCheck(AbilityHelper::canUseBrawlerAbilities);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.chargeComponent.isCharging()) {
            return;
        }
        if (this.continuousComponent.isContinuous()) {
            this.grabComponent.release(entity);
            this.continuousComponent.stopContinuity(entity);
        } else if (this.grabComponent.grabNearest(entity, false)) {
            this.chargeComponent.startCharging(entity, 20.0f);
        } else {
            this.continuousComponent.startContinuity(entity);
        }
    }

    private boolean onHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (!this.continuousComponent.isContinuous() || this.grabComponent.hasGrabbedEntity()) {
            return true;
        }
        if (this.grabComponent.grabManually(entity, target)) {
            this.continuousComponent.stopContinuity(entity);
            this.chargeComponent.startCharging(entity, 20.0f);
        }
        target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 1));
        return false;
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.grabComponent.getState() != GrabEntityComponent.GrabState.GRABBED) {
            this.grabComponent.release(entity);
        }
        if (!this.grabComponent.canContinueGrab(entity)) {
            this.cooldownComponent.startCooldown(entity, 400.0f);
        }
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.animationComponent.start(entity, ModAnimations.POINT_RIGHT_ARM);
        LivingEntity grabbedTarget = this.grabComponent.getGrabbedEntity();
        if (grabbedTarget != null) {
            AbilityHelper.setDeltaMovement((Entity)grabbedTarget, 0.0, 0.0, 0.0);
        }
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (super.canUse(entity).isFail() || !this.grabComponent.canContinueGrab(entity)) {
            this.chargeComponent.stopCharging(entity);
            return;
        }
        LivingEntity target = this.grabComponent.getGrabbedEntity();
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 1));
        target.func_195064_c(new EffectInstance((Effect)ModEffects.GRABBED.get(), 2, 3));
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.grabComponent.hasGrabbedEntity()) {
            LivingEntity grabbedTarget = this.grabComponent.getGrabbedEntity();
            grabbedTarget.func_195064_c(new EffectInstance((Effect)ModEffects.FRAGILE.get(), 40, 0));
            ModDamageSource source = ModDamageSource.causeAbilityDamage(entity, super.getCore()).setPiercing(0.25f);
            this.dealDamageComponent.hurtTarget(entity, grabbedTarget, 50.0f, source);
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, entity.field_70170_p, grabbedTarget.func_226277_ct_(), grabbedTarget.func_226278_cu_(), grabbedTarget.func_226281_cx_(), 1.0f);
            explosion.setDestroyBlocks(false);
            explosion.disableExplosionKnockback();
            explosion.setSmokeParticles(new CommonExplosionParticleEffect(1));
            explosion.doExplosion();
            ItemStack stack = grabbedTarget.func_184582_a(EquipmentSlotType.HEAD);
            stack.func_222118_a(15, grabbedTarget, user -> user.func_213361_c(EquipmentSlotType.HEAD));
            this.grabComponent.release(entity);
        }
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 400.0f);
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isBrawler() && questProps.hasFinishedQuest(ModQuests.BRAWLER_TRIAL_04);
    }
}

