/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.chiyu;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ChiyupopoAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "chiyupopo", new Pair[]{ImmutablePair.of((Object)"Releases dandelions made of tears that temporarily increase the healing rate of those around the user. This can only be applied once per person.", null)});
    private static final float COOLDOWN = 16800.0f;
    private static final float RANGE = 15.0f;
    public static final AbilityCore<ChiyupopoAbility> INSTANCE = new AbilityCore.Builder<ChiyupopoAbility>("Chiyupopo", AbilityCategory.DEVIL_FRUITS, ChiyupopoAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(16800.0f), RangeComponent.getTooltip(15.0f, RangeComponent.RangeType.AOE)).build();
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private TargetsPredicate predicate;

    public ChiyupopoAbility(AbilityCore<ChiyupopoAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.rangeComponent);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity player, IAbility ability) {
        EntityStatsCapability.get(player).setChiyuEffect(false);
        if (this.predicate == null) {
            this.predicate = new TargetsPredicate().testFriendlyFaction().selector(entity -> !EntityStatsCapability.get(entity).hadChiyuEffect());
        }
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(player, 15.0f, this.predicate);
        if (ModEntityPredicates.getFriendlyFactions(player).test((Entity)player) && !EntityStatsCapability.get(player).hadChiyuEffect()) {
            targets.add(player);
        }
        for (LivingEntity entity2 : targets) {
            if (!entity2.func_195064_c(new EffectInstance((Effect)ModEffects.CHIYUPOPO.get(), 4800, 5))) continue;
            EntityStatsCapability.get(entity2).setChiyuEffect(true);
        }
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.CHIYUPOPO.get(), (Entity)player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
        this.cooldownComponent.startCooldown(player, 16800.0f);
    }
}

