/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.cyborg;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.GrabEntityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.api.math.EasingFunctionHelper;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SouthlandSuplexAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "southland_suplex", new Pair[]{ImmutablePair.of((Object)"The user grabs a person with both of their arms and smashes the opponent's head by throwing them backwards", null)});
    private static final int PULL_TIME = 200;
    private static final int CHARGE_TIME = 20;
    private static final int COOLDOWN = 140;
    private static final int DAMAGE = 20;
    private static final int COLLISION_DAMAGE = 10;
    public static final AbilityCore<SouthlandSuplexAbility> INSTANCE = new AbilityCore.Builder<SouthlandSuplexAbility>("Southland Suplex", AbilityCategory.RACIAL, SouthlandSuplexAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(140.0f), ChargeComponent.getTooltip(20.0f), DealDamageComponent.getTooltip(20.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).setUnlockCheck(SouthlandSuplexAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addEndEvent(this::onContinuityEnd);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final GrabEntityComponent grabComponent = new GrabEntityComponent(this, true, false, true, 2.0f).addPullStartEvent(this::onPullStart).addPullEndEvent(this::onPullEnd);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent(this).addOnHitEvent(this::onHitEvent);
    private final PoolComponent poolComponent = new PoolComponent(this, ModAbilityPools.GRAB_ABILITY, new AbilityPool2[0]);

    public SouthlandSuplexAbility(AbilityCore<SouthlandSuplexAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.dealDamageComponent, this.chargeComponent, this.animationComponent, this.grabComponent, this.hitTriggerComponent, this.poolComponent);
        this.addCanUseCheck(AbilityHelper::canUseBrawlerAbilities);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.chargeComponent.isCharging()) {
            return;
        }
        if (this.continuousComponent.isContinuous()) {
            this.grabComponent.release(entity);
            this.continuousComponent.stopContinuity(entity);
        } else if (this.grabComponent.grabNearest(entity, false)) {
            this.grabComponent.triggerPulling(entity);
        } else {
            this.continuousComponent.startContinuity(entity);
        }
    }

    private boolean onHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (!this.continuousComponent.isContinuous() || this.grabComponent.hasGrabbedEntity()) {
            return true;
        }
        if (this.grabComponent.grabManually(entity, target)) {
            this.grabComponent.startPulling(entity);
        }
        target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 1));
        return false;
    }

    public void onPullStart(LivingEntity entity, IAbility ability) {
        this.continuousComponent.setThresholdTime(entity, 200.0f);
    }

    public void onPullEnd(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        if (this.grabComponent.canContinueGrab(entity)) {
            this.chargeComponent.startCharging(entity, 20.0f);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.grabComponent.getState() != GrabEntityComponent.GrabState.GRABBED) {
            this.grabComponent.release(entity);
        }
        if (!this.grabComponent.canContinueGrab(entity)) {
            this.cooldownComponent.startCooldown(entity, 140.0f);
        }
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.POINT_ARMS);
    }

    public void onChargeTick(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (super.canUse(entity).isFail() || !this.grabComponent.canContinueGrab(entity)) {
            this.chargeComponent.stopCharging(entity);
            return;
        }
        LivingEntity grabbedTarget = this.grabComponent.getGrabbedEntity();
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 1));
        grabbedTarget.func_195064_c(new EffectInstance((Effect)ModEffects.GRABBED.get(), 2, 3));
        float distance = 1.0f;
        Vector3d lookVec = entity.func_70040_Z().func_72432_b();
        Vector3d pos = new Vector3d(lookVec.field_72450_a * (double)distance, (double)entity.func_213302_cg(), lookVec.field_72449_c * (double)distance).func_186678_a((double)this.chargeComponent.getChargePercentage());
        AbilityHelper.setDeltaMovement((Entity)grabbedTarget, entity.func_213303_ch().func_178786_a(pos.field_72450_a, (double)(-EasingFunctionHelper.easeInOutSine(Float.valueOf((float)pos.field_72448_b))), pos.field_72449_c).func_178788_d(grabbedTarget.func_213303_ch()), true);
    }

    public void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (this.grabComponent.hasGrabbedEntity()) {
            LivingEntity grabbedTarget = this.grabComponent.getGrabbedEntity();
            DamageSource source = this.dealDamageComponent.getDamageSource(entity);
            if (this.dealDamageComponent.hurtTarget(entity, grabbedTarget, 20.0f)) {
                grabbedTarget.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 40, 0));
            }
            List<LivingEntity> targets = WyHelper.getNearbyLiving(entity.func_213303_ch(), (IWorld)entity.field_70170_p, grabbedTarget.func_213311_cf(), grabbedTarget.func_213302_cg(), grabbedTarget.func_213311_cf(), ModEntityPredicates.getEnemyFactions(entity));
            targets.remove(grabbedTarget);
            if (!HakiHelper.hasHardeningActive(entity)) {
                targets.removeIf(target -> DevilFruitCapability.get(entity).isLogia());
            }
            for (LivingEntity target2 : targets) {
                if (!this.dealDamageComponent.hurtTarget(entity, target2, 10.0f)) continue;
                AbilityHelper.setDeltaMovement((Entity)target2, 0.0, -1.0, 0.0);
            }
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, entity.field_70170_p, grabbedTarget.func_226277_ct_(), grabbedTarget.func_226278_cu_(), grabbedTarget.func_226281_cx_(), 1.0f);
            explosion.setStaticDamage(6.0f);
            explosion.setExplosionSound(true);
            explosion.setDamageOwner(false);
            explosion.setDestroyBlocks(false);
            explosion.setFireAfterExplosion(false);
            explosion.setSmokeParticles(new CommonExplosionParticleEffect(1));
            explosion.setDamageEntities(true);
            explosion.setDamageSource(source);
            this.grabComponent.release(entity);
        }
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 140.0f);
    }

    private static boolean canUnlock(LivingEntity entity) {
        IEntityStats props = EntityStatsCapability.get(entity);
        return props.isCyborg();
    }
}

