/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.doku;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.entities.projectiles.doku.VenomRoadProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class VenomRoadAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "venom_road", new Pair[]{ImmutablePair.of((Object)"Fires a Hydra at the target location that stays there for a few seconds during which time the user can use them to move along their path.", null)});
    private static final ITextComponent NORMAL_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.venom_road", "Venom Road"));
    private static final ITextComponent VENOM_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.venom_road_venom", "Demon Road"));
    private static final ResourceLocation NORMAL_ICON = new ResourceLocation("mineminenomi", "textures/abilities/venom_road.png");
    private static final ResourceLocation VENOM_ICON = new ResourceLocation("mineminenomi", "textures/abilities/venom_road_venom.png");
    public static final int COOLDOWN = 80;
    public static final AbilityCore<VenomRoadAbility> INSTANCE = new AbilityCore.Builder<VenomRoadAbility>("Venom Road", AbilityCategory.DEVIL_FRUITS, VenomRoadAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(80.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceElement(SourceElement.POISON).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final AltModeComponent<Mode> altModeComponent = new AltModeComponent<Mode>(this, Mode.class, Mode.NORMAL, true).addChangeModeEvent(this::onAltModeChange);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private boolean isMovingOwner;
    private int firstTick;
    private int ticks;
    private List<Pair<Vector3d, VenomRoadProjectile>> projectiles = new ArrayList<Pair<Vector3d, VenomRoadProjectile>>();
    private VenomRoadProjectile projectileUsed;

    public VenomRoadAbility(AbilityCore<VenomRoadAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.projectileComponent, this.altModeComponent, this.animationComponent);
        this.addUseEvent(this::useEvent);
        this.addTickEvent(this::tickEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (this.isMovingOwner) {
            return;
        }
        boolean isNearStartPoint = false;
        for (Pair<Vector3d, VenomRoadProjectile> pair2 : this.projectiles) {
            if (pair2.getValue() == null || !((VenomRoadProjectile)((Object)pair2.getValue())).func_70089_S() || !entity.func_213303_ch().func_237488_a_((IPosition)pair2.getKey(), 10.0)) continue;
            isNearStartPoint = true;
            this.projectileUsed = (VenomRoadProjectile)((Object)pair2.getValue());
            break;
        }
        if (isNearStartPoint && AbilityHelper.canUseMomentumAbilities(entity)) {
            entity.func_233576_c_(this.projectileUsed.getStartPos().func_72441_c(0.0, 1.0, 0.0));
            this.firstTick = this.ticks;
            this.isMovingOwner = true;
            this.animationComponent.start(entity, ModAnimations.SHOOT_SELF_FORWARD, 30);
        } else {
            this.projectiles.removeIf(pair -> pair.getValue() == null || !((VenomRoadProjectile)((Object)((Object)((Object)pair.getValue())))).func_70089_S());
            if (this.projectiles.size() > 2) {
                Pair firstPair = this.projectiles.stream().findFirst().orElse(null);
                if (firstPair == null) {
                    return;
                }
                ((VenomRoadProjectile)((Object)firstPair.getValue())).func_70106_y();
                this.projectiles.remove(firstPair);
            }
            this.isMovingOwner = false;
            VenomRoadProjectile projectile = (VenomRoadProjectile)((Object)this.projectileComponent.getNewProjectile(entity));
            entity.field_70170_p.func_217376_c((Entity)projectile);
            projectile.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 3.0f, 1.0f);
            ImmutablePair immutablePair = ImmutablePair.of((Object)entity.func_213303_ch(), (Object)((Object)projectile));
            this.projectiles.add((Pair<Vector3d, VenomRoadProjectile>)immutablePair);
            this.cooldownComponent.startCooldown(entity, 80.0f);
        }
    }

    private VenomRoadProjectile createProjectile(LivingEntity entity) {
        boolean isDemonForm = ((MorphInfo)ModMorphs.VENOM_DEMON.get()).isActive(entity);
        VenomRoadProjectile projectile = new VenomRoadProjectile(entity.field_70170_p, entity, this, isDemonForm);
        return projectile;
    }

    public void tickEvent(LivingEntity entity, IAbility ability) {
        ++this.ticks;
        if (!entity.field_70170_p.field_72995_K && this.isMovingOwner) {
            boolean pushedForTooLong;
            boolean hasArrived = entity.func_213303_ch().func_237488_a_((IPosition)this.projectileUsed.func_213303_ch(), 10.0);
            boolean bl = pushedForTooLong = this.ticks - this.firstTick > 40;
            if (hasArrived || pushedForTooLong) {
                this.isMovingOwner = false;
                this.cooldownComponent.startCooldown(entity, 80.0f);
                entity.field_70143_R = 0.0f;
                return;
            }
            if (AbilityHelper.canUseMomentumAbilities(entity)) {
                Vector3d vec = this.projectileUsed.func_213303_ch().func_72441_c(0.0, 1.0, 0.0).func_178788_d(this.projectileUsed.getStartPos()).func_72432_b().func_186678_a(3.0);
                AbilityHelper.setDeltaMovement((Entity)entity, vec);
                entity.field_70143_R = 0.0f;
            }
        }
    }

    public void setNormalMode(LivingEntity entity) {
        this.altModeComponent.setMode(entity, Mode.NORMAL);
    }

    public void setVenomMode(LivingEntity entity) {
        this.altModeComponent.setMode(entity, Mode.VENOM);
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.VENOM) {
            super.setDisplayName(VENOM_NAME);
            super.setDisplayIcon(VENOM_ICON);
        } else if (mode == Mode.NORMAL) {
            super.setDisplayName(NORMAL_NAME);
            super.setDisplayIcon(NORMAL_ICON);
        }
    }

    private static enum Mode {
        NORMAL,
        VENOM;

    }
}

