/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.doru;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.doru.DoruDoruArtsMoriAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.MorphAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;

public class CandleChampionAbility
extends MorphAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "candle_champion", new Pair[]{ImmutablePair.of((Object)"The user covers themselves in a thick wax coating, creating a battle suit protecting the user and increasing their offensive capabilities.", null), ImmutablePair.of((Object)"While active transforms \u00a72Doru Doru Arts: Mori\u00a7r into \u00a72Champ Fight\u00a7r", null)});
    private static final float HOLD_TIME = 1200.0f;
    private static final float MIN_COOLDOWN = 40.0f;
    private static final float MAX_COOLDOWN = 1240.0f;
    public static final AbilityCore<CandleChampionAbility> INSTANCE = new AbilityCore.Builder<CandleChampionAbility>("Candle Champion", AbilityCategory.DEVIL_FRUITS, CandleChampionAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(40.0f, 1240.0f), ContinuousComponent.getTooltip(1200.0f)).build();
    private static final AbilityAttributeModifier STRENGTH_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_STRENGTH_UUID, INSTANCE, "Candle Champion Attack Damage Modifier", 4.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ATTACK_SPEED_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ATTACK_SPEED_UUID, INSTANCE, "Candle Champion Attack Speed Modifier", (double)0.1f, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier REACH_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ATTACK_REACH_UUID, INSTANCE, "Candle Champion Reach Modifier", 0.3, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ARMOR_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ARMOR_UUID, INSTANCE, "Candle Champion Armor Modifier", 15.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier KNOCKBACK_RESISTANCE = new AbilityAttributeModifier(AttributeHelper.MORPH_KNOCKBACK_RESISTANCE_UUID, INSTANCE, "Candle Champion Knockback Resistance Modifier", 2.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier FALL_RESISTANCE_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_FALL_RESISTANCE_UUID, INSTANCE, "Candle Champion Fall Resistance Modifier", 5.0, AttributeModifier.Operation.ADDITION);

    public CandleChampionAbility(AbilityCore<CandleChampionAbility> core) {
        super(core);
        this.continuousComponent.addStartEvent(100, this::startContinuityEvent);
        this.continuousComponent.addTickEvent(100, this::tickContinuityEvent);
        this.continuousComponent.addEndEvent(100, this::endContinuityEvent);
        Predicate<LivingEntity> isContinuityActive = entity -> this.continuousComponent.isContinuous();
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)STRENGTH_MODIFIER, isContinuityActive);
        this.statsComponent.addAttributeModifier(Attributes.field_233825_h_, (AttributeModifier)ATTACK_SPEED_MODIFIER, isContinuityActive);
        this.statsComponent.addAttributeModifier(Attributes.field_233826_i_, (AttributeModifier)ARMOR_MODIFIER, isContinuityActive);
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ForgeMod.REACH_DISTANCE, (AttributeModifier)REACH_MODIFIER, isContinuityActive);
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.ATTACK_RANGE, (AttributeModifier)REACH_MODIFIER, isContinuityActive);
        this.statsComponent.addAttributeModifier(Attributes.field_233820_c_, (AttributeModifier)KNOCKBACK_RESISTANCE, isContinuityActive);
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.FALL_RESISTANCE, (AttributeModifier)FALL_RESISTANCE_MODIFIER, isContinuityActive);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        IAbilityData props = AbilityDataCapability.get(entity);
        DoruDoruArtsMoriAbility doruArtsMori = props.getEquippedAbility(DoruDoruArtsMoriAbility.INSTANCE);
        if (doruArtsMori != null) {
            doruArtsMori.changeToChampFight(entity);
        }
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_70027_ad()) {
            this.continuousComponent.increaseContinuityTime(5.0f);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        IAbilityData props = AbilityDataCapability.get(entity);
        DoruDoruArtsMoriAbility doruArtsMori = props.getEquippedAbility(DoruDoruArtsMoriAbility.INSTANCE);
        if (doruArtsMori != null) {
            doruArtsMori.changeToDefault(entity);
        }
        float cooldown = 40.0f + this.continuousComponent.getContinueTime();
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    @Override
    public float getContinuityHoldTime() {
        return 1200.0f;
    }

    @Override
    public MorphInfo getTransformation() {
        return (MorphInfo)ModMorphs.CANDLE_CHAMPION.get();
    }
}

