/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.doru;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.doru.CandleChampionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;

public class CandleHouseAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "candle_house", new Pair[]{ImmutablePair.of((Object)"Creates a big house-like structure made of wax, to protect the user", null)});
    private static final float COOLDOWN = 1000.0f;
    public static final AbilityCore<CandleHouseAbility> INSTANCE = new AbilityCore.Builder<CandleHouseAbility>("Candle House", AbilityCategory.DEVIL_FRUITS, CandleHouseAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(1000.0f)).build();
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(AirBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE).build();

    public CandleHouseAbility(AbilityCore<CandleHouseAbility> core) {
        super(core);
        this.isNew = true;
        this.addUseEvent(100, this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility abiltiy) {
        boolean isAcitve;
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        int thiccness = 1;
        CandleChampionAbility candleChampionAbility = AbilityDataCapability.get(entity).getEquippedAbility(CandleChampionAbility.INSTANCE);
        if (candleChampionAbility != null && (isAcitve = candleChampionAbility.getComponent(ModAbilityKeys.CONTINUOUS).map(ContinuousComponent::isContinuous).orElse(false).booleanValue())) {
            thiccness = 3;
        }
        BlockState defaultWaxState = ((Block)ModBlocks.WAX.get()).func_176223_P();
        for (int y = -3; y <= 3; ++y) {
            int z;
            int x;
            for (x = 0; x < thiccness; ++x) {
                for (z = -5; z < 5; ++z) {
                    AbilityHelper.placeBlockIfAllowed(entity, entity.func_233580_cy_().func_177982_a(6 - x, y, -z), defaultWaxState, GRIEF_RULE);
                }
            }
            for (x = 0; x < thiccness; ++x) {
                for (z = -5; z < 5; ++z) {
                    AbilityHelper.placeBlockIfAllowed(entity, entity.func_233580_cy_().func_177982_a(-5 - x, y, -z), defaultWaxState, GRIEF_RULE);
                }
            }
            for (x = -5; x < 5; ++x) {
                for (z = 0; z < thiccness; ++z) {
                    AbilityHelper.placeBlockIfAllowed(entity, entity.func_233580_cy_().func_177982_a(-x, y, 6 - z), defaultWaxState, GRIEF_RULE);
                }
            }
            for (x = -5; x < 5; ++x) {
                for (z = 0; z < thiccness; ++z) {
                    AbilityHelper.placeBlockIfAllowed(entity, entity.func_233580_cy_().func_177982_a(-x, y, -5 - z), defaultWaxState, GRIEF_RULE);
                }
            }
        }
        for (int x = -5; x < 5; ++x) {
            for (int z = -5; z < 5; ++z) {
                AbilityHelper.placeBlockIfAllowed(entity, entity.func_233580_cy_().func_177982_a(-x, 4, -z), defaultWaxState, GRIEF_RULE);
            }
        }
        this.cooldownComponent.startCooldown(entity, 1000.0f);
    }
}

