/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.electro;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.electro.EleclawAbility;
import xyz.pixelatedw.mineminenomi.abilities.electro.ElectroHelper;
import xyz.pixelatedw.mineminenomi.abilities.electro.SulongAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SwingTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.projectiles.electro.ElectricalLunaProjectile;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ElectricalLunaAbility
extends Ability {
    private static final float COOLDOWN_BONUS = 0.3f;
    private static final float DAMAGE_BONUS = 2.0f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "electrical_luna", new Pair[]{ImmutablePair.of((Object)"Charges a lightning ball in the user's hand which will be used whenever the user swings their arm, shooting the ball of electricity towards their target. On impact the ball will cause a small area of effect that stuns all nearby enemies but only damages the main target.", null), ImmutablePair.of((Object)"While %s is active the cooldown of this ability is reduced by %s and the damage is increased by %s.", (Object)new Object[]{AbilityHelper.mentionAbility(SulongAbility.INSTANCE), AbilityHelper.mentionText(Math.round(70.0f) + "%"), AbilityHelper.mentionText(Math.round(Math.abs(-1.0f) * 100.0f) + "%")})});
    private static final int COOLDOWN = 200;
    private static final int CHARGE_TIME = 40;
    public static final int RANGE = 6;
    private static final int DAMAGE = 40;
    private static final int ELECLAW_STACKS = 2;
    public static final AbilityCore<ElectricalLunaAbility> INSTANCE = new AbilityCore.Builder<ElectricalLunaAbility>("Electrical Luna", AbilityCategory.RACIAL, ElectricalLunaAbility::new).addDescriptionLine(DESCRIPTION[0]).addAdvancedDescriptionLine(AbilityDescriptionLine.IDescriptionLine.of(DESCRIPTION[1])).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), ChargeComponent.getTooltip(40.0f), RangeComponent.getTooltip(6.0f, RangeComponent.RangeType.AOE)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.LIGHTNING).setUnlockCheck(ElectricalLunaAbility::canUnlock).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addEndEvent(this::endContinuityEvent);
    private final SwingTriggerComponent swingTriggerComponent = new SwingTriggerComponent(this).addSwingEvent(this::swingEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);

    public ElectricalLunaAbility(AbilityCore<ElectricalLunaAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.continuousComponent, this.swingTriggerComponent, this.projectileComponent);
        this.addCanUseCheck(ElectroHelper.requireEleclaw(2));
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (this.chargeComponent.isCharging() || this.continuousComponent.isContinuous()) {
            return;
        }
        this.chargeComponent.startCharging(entity, 40.0f);
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 0, false, false));
        if (this.chargeComponent.getChargeTime() % 2.0f == 0.0f) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.ELECTRO_CHARGING.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        boolean hasSulongActive = ElectroHelper.hasSulongActive(entity);
        this.projectileComponent.getDamageBonusManager().removeBonus(ElectroHelper.SULONG_DAMAGE_BONUS);
        this.cooldownComponent.getBonusManager().removeBonus(ElectroHelper.SULONG_COOLDOWN_BONUS);
        if (hasSulongActive) {
            this.projectileComponent.getDamageBonusManager().addBonus(ElectroHelper.SULONG_DAMAGE_BONUS, "Sulong Damage Bonus", BonusOperation.MUL, 2.0f);
            this.cooldownComponent.getBonusManager().addBonus(ElectroHelper.SULONG_COOLDOWN_BONUS, "Sulong Cooldown Bonus", BonusOperation.MUL, 0.3f);
        }
        this.continuousComponent.startContinuity(entity);
        EleclawAbility eleclawAbility = AbilityDataCapability.get(entity).getEquippedAbility(EleclawAbility.INSTANCE);
        if (eleclawAbility != null) {
            eleclawAbility.reduceUsage(entity, 2);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }

    private void swingEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.continuousComponent.stopContinuity(entity);
            this.projectileComponent.shoot(entity, 3.0f, 0.0f);
        }
    }

    private ElectricalLunaProjectile createProjectile(LivingEntity entity) {
        ElectricalLunaProjectile proj = new ElectricalLunaProjectile(entity.field_70170_p, entity, this);
        proj.setDamage(40.0f);
        proj.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 3.0f, 0.0f);
        return proj;
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get(user);
        return props.isMink() && props.getDoriki() >= 3600.0;
    }
}

