/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.electro;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.electro.EleclawAbility;
import xyz.pixelatedw.mineminenomi.abilities.electro.ElectroHelper;
import xyz.pixelatedw.mineminenomi.abilities.electro.SulongAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.StackComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.LightningDischargeEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.electro.ElectricalShowerProjectile;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ElectricalShowerAbility
extends Ability {
    private static final float COOLDOWN_BONUS = 0.3f;
    private static final float DAMAGE_BONUS = 1.25f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "electrical_shower", new Pair[]{ImmutablePair.of((Object)"Launches the user into the air and showers down lightning bolts underneath.", null), ImmutablePair.of((Object)"While %s is active the cooldown of this ability is reduced by %s and the damage is increased by %s.", (Object)new Object[]{AbilityHelper.mentionAbility(SulongAbility.INSTANCE), AbilityHelper.mentionText(Math.round(70.0f) + "%"), AbilityHelper.mentionText(Math.round(Math.abs(-0.25f) * 100.0f) + "%")})});
    private static final int COOLDOWN = 240;
    private static final int CHARGE_TIME = 60;
    private static final int DAMAGE = 20;
    private static final int ELECLAW_STACKS = 2;
    public static final AbilityCore<ElectricalShowerAbility> INSTANCE = new AbilityCore.Builder<ElectricalShowerAbility>("Electrical Shower", AbilityCategory.RACIAL, ElectricalShowerAbility::new).addDescriptionLine(DESCRIPTION[0]).addAdvancedDescriptionLine(AbilityDescriptionLine.IDescriptionLine.of(DESCRIPTION[1])).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(240.0f), ChargeComponent.getTooltip(60.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.LIGHTNING).setUnlockCheck(ElectricalShowerAbility::canUnlock).build();
    private final StackComponent stackComponent = new StackComponent(this);
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this).addOnAttackEvent(this::onDamageTaken);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final RepeaterComponent repeaterComponent = new RepeaterComponent(this).addTriggerEvent(this::triggerRepeaterEvent).addStopEvent(this::stopRepeaterEvent);
    private LightningDischargeEntity ballEntity = null;
    boolean hasFallDamage = true;

    public ElectricalShowerAbility(AbilityCore<ElectricalShowerAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.stackComponent, this.chargeComponent, this.damageTakenComponent, this.projectileComponent, this.continuousComponent, this.repeaterComponent);
        this.addCanUseCheck(ElectroHelper.requireEleclaw(2));
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (this.isContinuous()) {
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        this.chargeComponent.startCharging(entity, 60.0f);
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        Vector3d startVec;
        boolean blockUnder;
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 0, false, false));
        if (this.chargeComponent.getChargeTime() % 5.0f == 0.0f) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.ELECTRO_CHARGING.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        }
        float percentage = 1.0f - this.chargeComponent.getChargeTime() / this.chargeComponent.getMaxChargeTime();
        if (this.ballEntity == null) {
            LightningDischargeEntity ball;
            this.ballEntity = ball = new LightningDischargeEntity((Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
        } else {
            float distance = percentage * 2.0f;
            Vector3d lookVec = entity.func_70040_Z();
            double px = entity.func_226277_ct_() + lookVec.field_72450_a * (double)distance;
            double py = entity.func_226280_cw_() * 0.85 + lookVec.field_72448_b * (double)distance;
            double pz = entity.func_226281_cx_() + lookVec.field_72449_c * (double)distance;
            Vector3d pos = new Vector3d(px, py, pz);
            this.ballEntity.setSize(percentage * 0.3f);
            this.ballEntity.setLightningLength(3.0f);
            this.ballEntity.func_70012_b(pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), entity.field_70177_z, entity.field_70125_A);
        }
        if ((double)percentage > 0.65 && (blockUnder = entity.field_70170_p.func_217299_a(new RayTraceContext(startVec = entity.func_213303_ch(), startVec.func_72441_c(0.0, -15.0, 0.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)entity)).func_216346_c().equals((Object)RayTraceResult.Type.BLOCK))) {
            AbilityHelper.setDeltaMovement((Entity)entity, entity.func_213322_ci().field_72450_a, 1.0, entity.func_213322_ci().field_72449_c);
        }
        AbilityHelper.slowEntityFall(entity);
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        EleclawAbility eleclaw;
        if (this.ballEntity != null) {
            this.ballEntity.func_70106_y();
            this.ballEntity = null;
        }
        if ((eleclaw = AbilityDataCapability.get(entity).getEquippedAbility(EleclawAbility.INSTANCE)) != null) {
            eleclaw.reduceUsage(entity, 2);
        }
        this.continuousComponent.startContinuity(entity);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hasFallDamage = false;
        this.repeaterComponent.start(entity, 10, 5);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        AbilityHelper.slowEntityFall(entity);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 240.0f);
    }

    private void triggerRepeaterEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 3.0f, 2.0f);
        entity.func_226292_a_(Hand.MAIN_HAND, true);
    }

    private void stopRepeaterEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.hasFallDamage && damageSource == DamageSource.field_76379_h) {
            this.hasFallDamage = true;
            return 0.0f;
        }
        return damage;
    }

    private ElectricalShowerProjectile createProjectile(LivingEntity entity) {
        ElectricalShowerProjectile proj = new ElectricalShowerProjectile(entity.field_70170_p, entity);
        proj.setDamage(20.0f);
        proj.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 3.0f, 0.0f);
        return proj;
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get(user);
        return props.isMink() && props.getDoriki() >= 7000.0;
    }
}

