/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.fishmankarate;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.fishmankarate.MizuTaihoProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class MizuTaihoAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "mizu_taiho", new Pair[]{ImmutablePair.of((Object)"Launches a giant bubble, dealing massive damage and exploding on contact.", null)});
    private static final int COOLDOWN = 340;
    private static final int CHARGE_TIME = 30;
    public static final AbilityCore<MizuTaihoAbility> INSTANCE = new AbilityCore.Builder<MizuTaihoAbility>("Mizu Taiho", AbilityCategory.RACIAL, MizuTaihoAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(340.0f), ChargeComponent.getTooltip(30.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(100, this::startChargeEvent).addEndEvent(100, this::endChargeEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final AnimationComponent animationComponent = new AnimationComponent(this);

    public MizuTaihoAbility(AbilityCore<MizuTaihoAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.projectileComponent, this.animationComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 30.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.CROSSED_ARMS);
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.MIZU_TAIHO.get(), (Entity)entity, entity.func_226277_ct_(), 1.5 + entity.func_226278_cu_(), entity.func_226281_cx_());
        this.animationComponent.stop(entity);
        this.projectileComponent.shoot(entity, 2.0f, 0.0f);
        this.cooldownComponent.startCooldown(entity, 340.0f);
    }

    private MizuTaihoProjectile createProjectile(LivingEntity entity) {
        MizuTaihoProjectile projectile = new MizuTaihoProjectile(entity.field_70170_p, entity);
        return projectile;
    }
}

