/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.fishmankarate;

import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class SharkOnToothAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "shark_on_tooth", new Pair[]{ImmutablePair.of((Object)"Launches the user forward while spinning, biting the first enemy it comes in contact with.", null)});
    private static final int COOLDOWN = 300;
    private static final int HOLD_TIME = 15;
    private static final float RANGE = 1.5f;
    private static final float DAMAGE = 40.0f;
    public static final AbilityCore<SharkOnToothAbility> INSTANCE = new AbilityCore.Builder<SharkOnToothAbility>("Shark on Tooth", AbilityCategory.RACIAL, SharkOnToothAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(300.0f), DealDamageComponent.getTooltip(40.0f), RangeComponent.getTooltip(1.5f, RangeComponent.RangeType.LINE)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.PHYSICAL).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(100, this::startContinuityEvent).addTickEvent(100, this::tickContinuityEvent).addEndEvent(100, this::endContinuityEvent);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private boolean hitTarget = false;

    public SharkOnToothAbility(AbilityCore<SharkOnToothAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.rangeComponent, this.dealDamageComponent, this.animationComponent);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.startContinuity(entity, 15.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hitTarget = false;
        this.animationComponent.start(entity, ModAnimations.SHARK_ON_TOOTH);
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.DASH_ABILITY_SWOOSH_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        block1: {
            List<LivingEntity> targets;
            Iterator<LivingEntity> iterator;
            if (!entity.func_70089_S()) break block1;
            Vector3d look = entity.func_70040_Z();
            Vector3d speed = look.func_216372_d(2.3, 0.0, 2.3);
            entity.func_213315_a(MoverType.SELF, speed);
            if (!this.hitTarget && (iterator = (targets = this.rangeComponent.getTargetsInLine(entity, 1.0f, 1.5f)).iterator()).hasNext()) {
                LivingEntity target = iterator.next();
                this.dealDamageComponent.hurtTarget(entity, target, 40.0f);
                this.hitTarget = true;
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }

    public boolean hasHitTarget() {
        return this.hitTarget;
    }
}

