/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gomu;

import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GomuHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.RepeaterAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gomu.GomuGomuNoElephantGunProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gomu.GomuGomuNoJetPistolProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gomu.GomuGomuNoKingKongGunProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gomu.GomuGomuNoPistolProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class GomuGomuNoGatlingAbility
extends RepeaterAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "gomu_gomu_no_gatling", new Pair[]{ImmutablePair.of((Object)"Rapidly punches enemies in front of the user.", null)});
    private static final TranslationTextComponent GOMU_GOMU_NO_GATLING_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.gomu_gomu_no_gatling", "Gomu Gomu no Gatling"));
    private static final TranslationTextComponent GOMU_GOMU_NO_JET_GATLING_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.gomu_gomu_no_jet_gatling", "Gomu Gomu no Jet Gatling"));
    private static final TranslationTextComponent GOMU_GOMU_NO_ELEPHANT_GATLING_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.gomu_gomu_no_elephant_gatling", "Gomu Gomu no Elephant Gatling"));
    private static final TranslationTextComponent GOMU_GOMU_NO_KONG_GATLING_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.gomu_gomu_no_kong_gatling", "Gomu Gomu no Kong Gatling"));
    private static final ResourceLocation GOMU_GOMU_NO_GATLING_ICON = new ResourceLocation("mineminenomi", "textures/abilities/gomu_gomu_no_gatling.png");
    private static final ResourceLocation GOMU_GOMU_NO_JET_GATLING_ICON = new ResourceLocation("mineminenomi", "textures/abilities/gomu_gomu_no_jet_gatling.png");
    private static final ResourceLocation GOMU_GOMU_NO_ELEPHANT_GATLING_ICON = new ResourceLocation("mineminenomi", "textures/abilities/gomu_gomu_no_elephant_gatling.png");
    private static final ResourceLocation GOMU_GOMU_NO_KONG_GATLING_ICON = new ResourceLocation("mineminenomi", "textures/abilities/gomu_gomu_no_kong_gatling.png");
    private static final int NO_GEAR_COOLDOWN = 140;
    private static final int NO_GEAR_TRIGGERS = 20;
    private static final int NO_GEAR_INTERVAL = 3;
    private static final int SECOND_GEAR_COOLDOWN = 100;
    private static final int SECOND_GEAR_TRIGGERS = 35;
    private static final int SECOND_GEAR_INTERVAL = 2;
    private static final int THIRD_GEAR_COOLDOWN = 250;
    private static final int THIRD_GEAR_TRIGGERS = 10;
    private static final int THIRD_GEAR_INTERVAL = 5;
    private static final int FOURTH_GEAR_COOLDOWN = 200;
    private static final int FOURTH_GEAR_TRIGGERS = 8;
    private static final int FOURTH_GEAR_INTERVAL = 5;
    private static final AbilityDescriptionLine.IDescriptionLine NO_GEAR_NAME_DESC = AbilityDescriptionLine.IDescriptionLine.of((ITextComponent)AbilityHelper.mentionText(GOMU_GOMU_NO_GATLING_NAME));
    private static final AbilityDescriptionLine.IDescriptionLine SECOND_GEAR_NAME_DESC = AbilityDescriptionLine.IDescriptionLine.of((ITextComponent)AbilityHelper.mentionText(GOMU_GOMU_NO_JET_GATLING_NAME));
    private static final AbilityDescriptionLine.IDescriptionLine THIRD_GEAR_NAME_DESC = AbilityDescriptionLine.IDescriptionLine.of((ITextComponent)AbilityHelper.mentionText(GOMU_GOMU_NO_ELEPHANT_GATLING_NAME));
    private static final AbilityDescriptionLine.IDescriptionLine FOURTH_GEAR_NAME_DESC = AbilityDescriptionLine.IDescriptionLine.of((ITextComponent)AbilityHelper.mentionText(GOMU_GOMU_NO_KONG_GATLING_NAME));
    public static final AbilityCore<GomuGomuNoGatlingAbility> INSTANCE = new AbilityCore.Builder<GomuGomuNoGatlingAbility>("Gomu Gomu no Gatling", AbilityCategory.DEVIL_FRUITS, GomuGomuNoGatlingAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, NO_GEAR_NAME_DESC, AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(140.0f)).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, SECOND_GEAR_NAME_DESC, GomuHelper.SECOND_GEAR_REQ, AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f)).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, THIRD_GEAR_NAME_DESC, GomuHelper.THIRD_GEAR_REQ, AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(250.0f)).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, FOURTH_GEAR_NAME_DESC, GomuHelper.FOURTH_GEAR_REQ, AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final AltModeComponent<GomuHelper.Gears> altModeComponent = new AltModeComponent<GomuHelper.Gears>(this, GomuHelper.Gears.class, GomuHelper.Gears.NO_GEAR, true).addChangeModeEvent(this::altModeChangeEvent);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private float projectileSpeed = 3.0f;
    private int projectileSpread = 2;
    private float cooldown = 140.0f;
    private int triggers = 20;
    private int interval = 3;

    public GomuGomuNoGatlingAbility(AbilityCore<GomuGomuNoGatlingAbility> core) {
        super((AbilityCore<? extends RepeaterAbility2>)core);
        this.isNew = true;
        this.addComponents(this.altModeComponent, this.animationComponent);
        this.setCustomShootLogic(living -> {
            for (int i = 0; i < 5; ++i) {
                AbilityProjectileEntity projectile = this.getProjectileFactory(living);
                this.projectileComponent.shootWithSpread(projectile, living, this.projectileSpeed, 3.0f, this.projectileSpread);
            }
        });
        this.repeaterComponent.addTriggerEvent(100, this::triggerRepeaterEvent);
        this.continuousComponent.addStartEvent(100, this::startContinuityEvent);
        this.continuousComponent.addTickEvent(100, this::tickContinuityEvent);
        this.continuousComponent.addEndEvent(100, this::endContinuityEvent);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.PUNCH_RUSH);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 1, false, false));
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
    }

    private void triggerRepeaterEvent(LivingEntity entity, IAbility ability) {
        entity.func_226292_a_(Hand.MAIN_HAND, true);
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.GOMU_SFX.get(), SoundCategory.PLAYERS, 2.0f, 0.6f + this.random.nextFloat() / 2.0f);
    }

    private void altModeChangeEvent(LivingEntity entity, IAbility ability, GomuHelper.Gears mode) {
        switch (mode) {
            case GEAR_2: {
                this.setDisplayName((ITextComponent)GOMU_GOMU_NO_JET_GATLING_NAME);
                this.cooldown = 100.0f;
                this.triggers = 35;
                this.interval = 2;
                break;
            }
            case GEAR_3: {
                this.setDisplayName((ITextComponent)GOMU_GOMU_NO_ELEPHANT_GATLING_NAME);
                this.cooldown = 250.0f;
                this.triggers = 10;
                this.interval = 5;
                break;
            }
            case GEAR_4: {
                this.setDisplayName((ITextComponent)GOMU_GOMU_NO_KONG_GATLING_NAME);
                this.cooldown = 200.0f;
                this.triggers = 8;
                this.interval = 5;
                break;
            }
            case GEAR_5: {
                break;
            }
            default: {
                this.setDisplayIcon(GOMU_GOMU_NO_GATLING_ICON);
                this.setDisplayName((ITextComponent)GOMU_GOMU_NO_GATLING_NAME);
                this.cooldown = 140.0f;
                this.triggers = 20;
                this.interval = 3;
            }
        }
    }

    public void switchNoGear(LivingEntity entity) {
        this.altModeComponent.setMode(entity, GomuHelper.Gears.NO_GEAR);
    }

    public void switchSecondGear(LivingEntity entity) {
        this.altModeComponent.setMode(entity, GomuHelper.Gears.GEAR_2);
    }

    public void switchThirdGear(LivingEntity entity) {
        this.altModeComponent.setMode(entity, GomuHelper.Gears.GEAR_3);
    }

    public void switchFourthGear(LivingEntity entity) {
        this.altModeComponent.setMode(entity, GomuHelper.Gears.GEAR_4);
    }

    public void switchFifthGear(LivingEntity entity) {
        this.altModeComponent.setMode(entity, GomuHelper.Gears.GEAR_5);
    }

    @Override
    public int getMaxTriggers() {
        return this.triggers;
    }

    @Override
    public int getTriggerInterval() {
        return this.interval;
    }

    @Override
    public float getRepeaterCooldown() {
        return this.cooldown;
    }

    public AbilityProjectileEntity getProjectileFactory(LivingEntity entity) {
        IAbilityData props = AbilityDataCapability.get(entity);
        AbilityProjectileEntity projectile = null;
        this.projectileSpeed = 3.0f;
        float projDmageReduction = 0.8f;
        this.projectileSpread = 2;
        if (GomuHelper.hasGearFourthActive(props)) {
            projectile = new GomuGomuNoKingKongGunProjectile(entity.field_70170_p, entity, this);
            projectile.setEntityCollisionSize(2.5);
            this.projectileSpeed = 2.2f;
            this.projectileSpread = 6;
            projDmageReduction = 0.6f;
        } else if (GomuHelper.hasGearThirdActive(props)) {
            projectile = new GomuGomuNoElephantGunProjectile(entity.field_70170_p, entity, this);
            projectile.setEntityCollisionSize(2.5);
            this.projectileSpeed = 2.4f;
            this.projectileSpread = 9;
            projDmageReduction = 0.6f;
        } else if (GomuHelper.hasGearSecondActive(props)) {
            projectile = new GomuGomuNoJetPistolProjectile(entity.field_70170_p, entity, this);
            this.projectileSpeed = 3.6f;
        } else {
            projectile = new GomuGomuNoPistolProjectile(entity.field_70170_p, entity);
        }
        projectile.setDamage(projectile.getDamage() * (1.0f - projDmageReduction));
        projectile.setMaxLife((int)((double)projectile.getMaxLife() * 0.75));
        return projectile;
    }
}

