/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.goro;

import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.goro.ElThorAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.RaigoProjectile;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class RaigoAbility
extends Ability {
    private static final ResourceLocation DEFAULT_ICON = new ResourceLocation("mineminenomi", "textures/abilities/raigo.png");
    private static final ResourceLocation ALT_ICON = new ResourceLocation("mineminenomi", "textures/abilities/alts/raigo.png");
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "raigo", new Pair[]{ImmutablePair.of((Object)"The user shapes a vast quantity of prior-made thunderclouds into one giant, dark sphere charged with inordinate electricity.", null), ImmutablePair.of((Object)"The user causes the nearby thunderclouds to shower everything below them with dozens of massive lightning bolts that create fire wherever they strike", null), ImmutablePair.of((Object)"Can only be used during a thunderstorm.", null)});
    private static final ITextComponent DEATHPIEA_MAMARAGAN_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.mamaragan", "Mamaragan"));
    private static final ITextComponent DEATHPIEA_RAIGO_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.raigo", "Raigo"));
    private static final ResourceLocation DEATHPIEA_MAMARAGAN_ICON = new ResourceLocation("mineminenomi", "textures/abilities/mamaragan.png");
    private static final ResourceLocation DEATHPIEA_RAIGO_ICON = new ResourceLocation("mineminenomi", "textures/abilities/raigo.png");
    private static final int RAIGO_BASE_COOLDOWN = 1700;
    private static final int RAIGO_THUNDERSTORM_COOLDOWN = 700;
    private static final int RAIGO_BASE_CHARGE_TIME = 240;
    private static final int RAIGO_THUNDERSTORM_CHARGE_TIME = 100;
    private static final int MAMARAGAN_COOLDOWN = 1400;
    private static final int MAMARAGAN_HOLD_TIME = 1200;
    public static final AbilityCore<RaigoAbility> INSTANCE = new AbilityCore.Builder<RaigoAbility>("Raigo", AbilityCategory.DEVIL_FRUITS, RaigoAbility::new).addAdvancedDescriptionLine((e, a) -> DEATHPIEA_RAIGO_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[0], AbilityDescriptionLine.NEW_LINE, (e, a) -> ModI18n.ABILITY_DESCRIPTION_DURING_THUNDERSTORM.func_230532_e_(), CooldownComponent.getTooltip(700.0f), ChargeComponent.getTooltip(100.0f), (e, a) -> ModI18n.ABILITY_DESCRIPTION_WITHOUT_THUNDERSTORM.func_230532_e_(), CooldownComponent.getTooltip(1700.0f), ChargeComponent.getTooltip(240.0f), AbilityDescriptionLine.NEW_LINE).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, (e, a) -> DEATHPIEA_MAMARAGAN_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[1], (e, a) -> DESCRIPTION[2], AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(1400.0f), ContinuousComponent.getTooltip(1200.0f)).setSourceElement(SourceElement.LIGHTNING).setIcon(DEFAULT_ICON).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final AltModeComponent<Mode> altModeComponent = new AltModeComponent<Mode>(this, Mode.class, Mode.RAIGO).addChangeModeEvent(this::onAltModeChange);
    private final Interval spawnLightningInterval = new Interval(10);
    private RaigoProjectile raigoProjectile;
    private boolean isThundering = false;

    public RaigoAbility(AbilityCore<RaigoAbility> core) {
        super(core);
        this.setDisplayIcon(DEFAULT_ICON);
        if (ClientConfig.INSTANCE.isGoroBlue()) {
            this.setDisplayIcon(ALT_ICON);
        }
        this.isNew = true;
        super.addComponents(this.chargeComponent, this.continuousComponent, this.altModeComponent, this.projectileComponent);
        super.addUseEvent(this::onUseEvent);
        this.addEquipEvent(this::equipEvent);
    }

    public void equipEvent(LivingEntity entity, Ability ability) {
        this.setDisplayIcon(DEFAULT_ICON);
        if (ClientConfig.INSTANCE.isGoroBlue()) {
            this.setDisplayIcon(ALT_ICON);
        }
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        AbilityUseResult hasThunderstorm = this.canUseEvent(entity, ability);
        if (this.altModeComponent.getCurrentMode() == Mode.MAMARAGAN) {
            if (!this.continuousComponent.isContinuous() && hasThunderstorm.isFail()) {
                if (hasThunderstorm.getMessage() != null) {
                    entity.func_145747_a(hasThunderstorm.getMessage(), Util.field_240973_b_);
                }
                return;
            }
            this.spawnLightningInterval.restartIntervalToZero();
            this.continuousComponent.triggerContinuity(entity, 1200.0f);
        } else if (this.altModeComponent.getCurrentMode() == Mode.RAIGO) {
            if (this.continuousComponent.isContinuous()) {
                return;
            }
            if (!this.chargeComponent.isCharging()) {
                this.isThundering = hasThunderstorm.isSuccess();
                this.spawnLightningInterval.restartIntervalToZero();
                this.chargeComponent.startCharging(entity, this.isThundering ? 240.0f : 100.0f);
            } else if ((double)this.chargeComponent.getChargeTime() >= 20.0) {
                this.chargeComponent.stopCharging(entity);
            }
        }
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity);
        double x = mop.func_216347_e().field_72450_a;
        double y = mop.func_216347_e().field_72448_b;
        double z = mop.func_216347_e().field_72449_c;
        this.raigoProjectile = new RaigoProjectile(entity.field_70170_p, entity, this);
        this.raigoProjectile.func_70012_b(x, 128.0, z, 0.0f, 0.0f);
        entity.field_70170_p.func_217376_c((Entity)this.raigoProjectile);
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.raigoProjectile == null || !this.raigoProjectile.func_70089_S() || super.canUse(entity).isFail()) {
            this.chargeComponent.stopCharging(entity);
            return;
        }
        this.raigoProjectile.setLife(this.raigoProjectile.getMaxLife());
        this.raigoProjectile.increaseSize(this.isThundering ? 0.08f : 0.0032f);
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.continuousComponent.startContinuity(entity, WyHelper.secondsToTicks(10.0f));
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.altModeComponent.getCurrentMode() == Mode.RAIGO) {
            if (this.raigoProjectile == null || !this.raigoProjectile.func_70089_S()) {
                this.continuousComponent.stopContinuity(entity);
                return;
            }
            this.raigoProjectile.setLife(this.raigoProjectile.getMaxLife());
            AbilityHelper.setDeltaMovement((Entity)this.raigoProjectile, 0.0, -0.75, 0.0);
        } else if (this.altModeComponent.getCurrentMode() == Mode.MAMARAGAN && this.spawnLightningInterval.canTick()) {
            if (super.canUse(entity).isFail()) {
                this.continuousComponent.stopContinuity(entity);
                return;
            }
            double posX = WyHelper.randomWithRange(-200, 200);
            double posZ = WyHelper.randomWithRange(-200, 200);
            float multi = 0.46f;
            float travelLength = 144.0f;
            Vector3d pos = new Vector3d(entity.func_226277_ct_() + posX, 128.0, entity.func_226281_cx_() + posZ);
            LightningEntity boltInner = new LightningEntity((Entity)entity, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0f, 90.0f, travelLength, 24.0f, this.getCore());
            LightningEntity boltOuter = new LightningEntity((Entity)entity, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0f, 90.0f, travelLength, 24.0f, this.getCore());
            this.setBoltPropieties(boltInner, 2.0f, 0.0f, 90, 40, false, Color.WHITE, multi);
            this.setBoltPropieties(boltOuter, 2.5f, 70.0f, 100, 9999, true, ClientConfig.INSTANCE.isGoroBlue() ? ElThorAbility.BLUE_THUNDER : ElThorAbility.YELLOW_THUNDER, multi);
            boltOuter.seed = boltInner.seed;
            entity.field_70170_p.func_217376_c((Entity)boltInner);
            entity.field_70170_p.func_217376_c((Entity)boltOuter);
            entity.field_70170_p.func_184133_a(null, boltInner.func_233580_cy_(), (SoundEvent)ModSounds.EL_THOR_SFX.get(), SoundCategory.PLAYERS, 30.0f, 1.0f);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.altModeComponent.getCurrentMode() == Mode.RAIGO) {
            if (this.raigoProjectile != null && this.raigoProjectile.func_70089_S() && this.raigoProjectile.getLife() < this.raigoProjectile.getMaxLife()) {
                this.raigoProjectile.onBlockImpactEvent(this.raigoProjectile.func_233580_cy_());
                this.raigoProjectile.func_70106_y();
            }
            this.raigoProjectile = null;
            this.cooldownComponent.startCooldown(entity, this.isThundering ? 700.0f : 1700.0f);
        } else if (this.altModeComponent.getCurrentMode() == Mode.MAMARAGAN) {
            this.cooldownComponent.startCooldown(entity, 1400.0f);
        }
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.MAMARAGAN) {
            super.setDisplayName(DEATHPIEA_MAMARAGAN_NAME);
            super.setDisplayIcon(DEATHPIEA_MAMARAGAN_ICON);
        } else if (mode == Mode.RAIGO) {
            super.setDisplayName(DEATHPIEA_RAIGO_NAME);
            super.setDisplayIcon(DEATHPIEA_RAIGO_ICON);
        }
    }

    private AbilityUseResult canUseEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.func_72911_I()) {
            return AbilityUseResult.success();
        }
        return AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_THUNDERSTORM));
    }

    public void setBoltPropieties(LightningEntity bolt, float size, float damage, int timeAlive, int resetTime, boolean explodes, @Nullable Color color, float multiplier) {
        bolt.setBlocksAffectedLimit(30000);
        bolt.setAngle(160);
        bolt.setBranches(1);
        bolt.setSegments(1);
        bolt.setSize(size * multiplier);
        bolt.setBoxSizeDivision(0.225f);
        bolt.setLightningMovement(false);
        bolt.setExplosion(explodes ? (int)(10.0f * multiplier) : 0, true, 0.25f);
        if (color != null) {
            bolt.setColor(color);
        }
        bolt.setMaxLife(timeAlive);
        bolt.setDamage(damage * multiplier);
        bolt.setTargetTimeToReset(resetTime);
    }

    private RaigoProjectile createProjectile(LivingEntity entity) {
        RaigoProjectile proj = new RaigoProjectile(entity.field_70170_p, entity, this);
        return proj;
    }

    public static enum Mode {
        MAMARAGAN,
        RAIGO;

    }
}

