/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gura;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.GrabEntityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.math.VectorHelper;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.gura.AirCrackParticleEffect;

public class KabutowariAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "kabutowari", new Pair[]{ImmutablePair.of((Object)"The user grabs their opponent's head and concentrates their vibrations around it, resulting in crushing damage", null)});
    private static final AirCrackParticleEffect PARTICLES = new AirCrackParticleEffect();
    private static final int COOLDOWN = 200;
    private static final int CHARGE_TIME = 40;
    private static final int DAMAGE = 60;
    private static final int PULL_TIME = 200;
    public static final AbilityCore<KabutowariAbility> INSTANCE = new AbilityCore.Builder<KabutowariAbility>("Kabutowari", AbilityCategory.DEVIL_FRUITS, KabutowariAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), ChargeComponent.getTooltip(40.0f), DealDamageComponent.getTooltip(60.0f)).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceElement(SourceElement.SHOCKWAVE).build();
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addEndEvent(this::onContinuityEnd);
    private final GrabEntityComponent grabComponent = new GrabEntityComponent(this, true, false, true, 1.0f).addPullStartEvent(this::onPullStart).addPullEndEvent(this::onPullEnd);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent(this).addOnHitEvent(this::onHitEvent);
    private final PoolComponent poolComponent = new PoolComponent(this, ModAbilityPools.GRAB_ABILITY, new AbilityPool2[0]);

    public KabutowariAbility(AbilityCore<KabutowariAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.chargeComponent, this.animationComponent, this.dealDamageComponent, this.continuousComponent, this.grabComponent, this.hitTriggerComponent, this.poolComponent);
        super.addCanUseCheck(AbilityHelper::canUseBrawlerAbilities);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.chargeComponent.isCharging()) {
            return;
        }
        if (this.continuousComponent.isContinuous()) {
            this.grabComponent.release(entity);
            this.continuousComponent.stopContinuity(entity);
        } else if (this.grabComponent.grabNearest(entity, false)) {
            this.grabComponent.triggerPulling(entity);
        } else {
            this.continuousComponent.startContinuity(entity);
        }
    }

    private boolean onHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (!this.continuousComponent.isContinuous() || this.grabComponent.hasGrabbedEntity()) {
            return true;
        }
        if (this.grabComponent.grabManually(entity, target)) {
            this.grabComponent.startPulling(entity);
        }
        target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 1));
        return false;
    }

    public void onPullStart(LivingEntity entity, IAbility ability) {
        this.continuousComponent.setThresholdTime(entity, 200.0f);
    }

    public void onPullEnd(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        if (this.grabComponent.canContinueGrab(entity)) {
            this.chargeComponent.startCharging(entity, 40.0f);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.grabComponent.getState() != GrabEntityComponent.GrabState.GRABBED) {
            this.grabComponent.release(entity);
        }
        if (!this.grabComponent.canContinueGrab(entity)) {
            this.cooldownComponent.startCooldown(entity, 200.0f);
        }
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.animationComponent.start(entity, ModAnimations.POINT_RIGHT_ARM);
        LivingEntity grabbedTarget = this.grabComponent.getGrabbedEntity();
        int chargeTime = (int)this.chargeComponent.getMaxChargeTime();
        if (grabbedTarget != null) {
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.GURA_SFX.get(), SoundCategory.PLAYERS, 5.0f, 1.0f);
            grabbedTarget.func_195064_c(new EffectInstance((Effect)ModEffects.SEISMIC_BUBBLE.get(), chargeTime, 0));
            AbilityHelper.setDeltaMovement((Entity)grabbedTarget, 0.0, 0.0, 0.0);
        }
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (super.canUse(entity).isFail() || !this.grabComponent.canContinueGrab(entity)) {
            this.chargeComponent.stopCharging(entity);
            return;
        }
        LivingEntity target = this.grabComponent.getGrabbedEntity();
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 1));
        target.func_195064_c(new EffectInstance((Effect)ModEffects.GRABBED.get(), 2, 3));
        Vector3d pos = VectorHelper.calculateRotationBasedOffsetPosition(entity.func_213303_ch(), entity.field_70761_aq, 0.5, -target.func_70047_e(), (double)target.func_213311_cf() - 0.2);
        AbilityHelper.setDeltaMovement((Entity)target, pos.func_178788_d(target.func_213303_ch()), true);
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.grabComponent.hasGrabbedEntity()) {
            LivingEntity grabbedTarget = this.grabComponent.getGrabbedEntity();
            ModDamageSource source = ModDamageSource.causeAbilityDamage(entity, super.getCore()).setPiercing(0.75f);
            this.dealDamageComponent.hurtTarget(entity, grabbedTarget, 60.0f, source);
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, entity.field_70170_p, grabbedTarget.func_226277_ct_(), grabbedTarget.func_226278_cu_(), grabbedTarget.func_226281_cx_(), 2.0f);
            explosion.setStaticDamage(20.0f);
            explosion.setSmokeParticles(new CommonExplosionParticleEffect(2));
            explosion.doExplosion();
            ItemStack stack = grabbedTarget.func_184582_a(EquipmentSlotType.HEAD);
            stack.func_222118_a(15, grabbedTarget, user -> user.func_213361_c(EquipmentSlotType.HEAD));
            PARTICLES.spawn(grabbedTarget.field_70170_p, grabbedTarget.func_226277_ct_(), grabbedTarget.func_226280_cw_(), grabbedTarget.func_226281_cx_(), 0.0, 0.0, 0.0);
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.GURA_SFX.get(), SoundCategory.PLAYERS, 5.0f, 1.0f);
            grabbedTarget.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 40, 0));
            this.grabComponent.release(entity);
        }
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }
}

