/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.haki;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiHardeningAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.items.weapons.AbilitySwordItem;
import xyz.pixelatedw.mineminenomi.items.weapons.ModSwordItem;

public class BusoshokuHakiImbuingAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "busoshoku_haki_imbuing", new Pair[]{ImmutablePair.of((Object)"Covers the weapon of the user in Armament haki, making their weapon attacks stronger and being able to damage Logia users.", null)});
    public static final AbilityCore<BusoshokuHakiImbuingAbility> INSTANCE = new AbilityCore.Builder<BusoshokuHakiImbuingAbility>("Busoshoku Haki: Imbuing", AbilityCategory.HAKI, BusoshokuHakiImbuingAbility::new).addDescriptionLine(DESCRIPTION).setUnlockCheck(BusoshokuHakiImbuingAbility::canUnlock).setSourceType(SourceType.SLASH).setSourceHakiNature(SourceHakiNature.IMBUING).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::onContinuityStart).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent(this).addTryHitEvent(100, this::tryHitEvent).addOnHitEvent(100, this::onHitEvent);
    private final PoolComponent poolComponent = new PoolComponent(this, ModAbilityPools.IMBUING_BUSOSHOKU_HAKI, new AbilityPool2[0]);

    public BusoshokuHakiImbuingAbility(AbilityCore<BusoshokuHakiImbuingAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.hitTriggerComponent, this.poolComponent);
        this.addCanUseCheck(HakiHelper::canEnableHaki);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_184614_ca().func_77973_b() == ModWeapons.ENMA.get() && this.continuousComponent.isContinuous()) {
            return;
        }
        this.continuousComponent.triggerContinuity(entity);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.BUSOSHOKU_HAKI_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        boolean isOnMaxOveruse = HakiHelper.checkForHakiOveruse(entity, 1);
        if (isOnMaxOveruse) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        List<ItemStack> inventories = ItemsHelper.getAllInventoryItems(entity);
        for (ItemStack stack : inventories) {
            boolean hasDefaultImbuing = false;
            if (stack.func_77973_b() instanceof ModSwordItem && stack.func_77973_b() instanceof AbilitySwordItem) {
                hasDefaultImbuing = true;
            } else if (!(stack.func_77973_b() instanceof ModSwordItem)) {
                hasDefaultImbuing = stack.func_77984_f();
            }
            if (stack.func_190926_b() || !stack.func_77942_o() || !stack.func_77978_p().func_74767_n("imbuingHakiActive") || !hasDefaultImbuing) continue;
            stack.func_196082_o().func_82580_o("imbuingHakiActive");
        }
    }

    private HitTriggerComponent.HitResult tryHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            return HitTriggerComponent.HitResult.HIT;
        }
        return HitTriggerComponent.HitResult.PASS;
    }

    private boolean onHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            source.bypassLogia();
        }
        return true;
    }

    private static boolean canUnlock(LivingEntity user) {
        IAbilityData abilityProps = AbilityDataCapability.get(user);
        IHakiData props = HakiDataCapability.get(user);
        IEntityStats statsProps = EntityStatsCapability.get(user);
        boolean hasHardeningUnlocked = abilityProps.hasUnlockedAbility(BusoshokuHakiHardeningAbility.INSTANCE);
        return statsProps.getDoriki() > 4000.0 && (double)props.getBusoshokuHakiExp() > HakiHelper.getBusoshokuHardeningExpNeeded(user) || hasHardeningUnlocked;
    }
}

