/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.hana;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.hana.HanaHelper;
import xyz.pixelatedw.mineminenomi.abilities.hana.MilFleurAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.hana.CampoDeFloresEntity;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CampoDeFloresAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "campo_de_flores", new Pair[]{ImmutablePair.of((Object)"Sprouts multiple hands in front of the user stunning and sending all enemies in a radius flying", null)});
    private static final int COOLDOWN = 200;
    public static final int HOLD_TIME = 100;
    public static final int RANGE = 10;
    public static final int DAMAGE = 10;
    public static final AbilityCore<CampoDeFloresAbility> INSTANCE = new AbilityCore.Builder<CampoDeFloresAbility>("Campo de Flores", AbilityCategory.DEVIL_FRUITS, CampoDeFloresAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, HanaHelper.REQUIRES_MIL_FLEUR).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), ContinuousComponent.getTooltip(100.0f), RangeComponent.getTooltip(10.0f, RangeComponent.RangeType.AOE), DealDamageComponent.getTooltip(10.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::startContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private CampoDeFloresEntity campoDeFlores;

    public CampoDeFloresAbility(AbilityCore<CampoDeFloresAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.rangeComponent, this.dealDamageComponent);
        this.addCanUseCheck(this::requiresMilFleur);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 100.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity);
        this.campoDeFlores = new CampoDeFloresEntity(entity.field_70170_p, this);
        this.campoDeFlores.func_70107_b(mop.func_216347_e().field_72450_a, mop.func_216347_e().field_72448_b, mop.func_216347_e().field_72449_c);
        this.campoDeFlores.setOwner(entity);
        entity.field_70170_p.func_217376_c((Entity)this.campoDeFlores);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.campoDeFlores != null) {
            this.campoDeFlores.func_70106_y();
        }
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }

    private AbilityUseResult requiresMilFleur(LivingEntity entity, IAbility ability) {
        MilFleurAbility milFleur = AbilityDataCapability.get(entity).getEquippedAbility(MilFleurAbility.INSTANCE);
        if (milFleur != null && milFleur.isContinuous()) {
            return AbilityUseResult.success();
        }
        return AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_MISSING_DEPENDENCY_SINGLE, new Object[]{INSTANCE.getLocalizedName().getString(), MilFleurAbility.INSTANCE.getLocalizedName().getString()}));
    }
}

