/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.hana;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.hana.HanaHelper;
import xyz.pixelatedw.mineminenomi.abilities.hana.MilFleurAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.hana.HanaGenericEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.hana.HanaHandsEntity;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class DosFleurClutchAbility
extends Ability {
    private static final int MIL_DISTANCE = 30;
    private static final float DAMAGE_BONUS = 1.5f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "dos_fleur_clutch", new Pair[]{ImmutablePair.of((Object)"Sprouts two hands to cover the opponent, and then bends them backward with bone-breaking results.", null), ImmutablePair.of((Object)"While %s is active it will sprout on every enemy in a %s blocks radius and increase its damage by %s.", (Object)new Object[]{MilFleurAbility.INSTANCE, "\u00a7a30\u00a7r", "\u00a7a" + Math.round(Math.abs(-0.5f) * 100.0f) + "%\u00a7r"})});
    private static final TranslationTextComponent NORMAL_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.dos_fleur_clutch", "Dos Fleur: Clutch"));
    private static final TranslationTextComponent MIL_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.mil_fleur_clutch", "Mil Fleur: Clutch"));
    private static final ResourceLocation NORMAL_ICON = new ResourceLocation("mineminenomi", "textures/abilities/dos_fleur_clutch.png");
    private static final ResourceLocation MIL_ICON = new ResourceLocation("mineminenomi", "textures/abilities/mil_fleur_clutch.png");
    private static final int COOLDOWN = 120;
    private static final int NORMAL_DAMAGE = 10;
    public static final AbilityCore<DosFleurClutchAbility> INSTANCE = new AbilityCore.Builder<DosFleurClutchAbility>("Dos Fleur: Clutch", AbilityCategory.DEVIL_FRUITS, DosFleurClutchAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(120.0f), DealDamageComponent.getTooltip(10.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final AltModeComponent<MilFleurAbility.Mode> altModeComponent = new AltModeComponent<MilFleurAbility.Mode>(this, MilFleurAbility.Mode.class, MilFleurAbility.Mode.NORMAL, true).addChangeModeEvent(this::onAltModeChange);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);

    public DosFleurClutchAbility(AbilityCore<DosFleurClutchAbility> ability) {
        super(ability);
        this.isNew = true;
        this.addComponents(this.projectileComponent, this.animationComponent, this.altModeComponent, this.rangeComponent, this.dealDamageComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.CROSSED_ARMS, 7);
        MilFleurAbility milFleur = AbilityDataCapability.get(entity).getEquippedAbility(MilFleurAbility.INSTANCE);
        boolean hasMilFleur = milFleur != null && milFleur.isContinuous();
        this.dealDamageComponent.getBonusManager().removeBonus(HanaHelper.MIL_DAMAGE_BONUS);
        if (hasMilFleur) {
            this.dealDamageComponent.getBonusManager().addBonus(HanaHelper.MIL_DAMAGE_BONUS, "Mil Fleur Damage Bonus", BonusOperation.MUL, 1.5f);
            List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 30.0f);
            for (LivingEntity target : targets) {
                this.clutch(entity, (Entity)target);
            }
        } else {
            this.projectileComponent.shoot(entity, 6.0f, 0.0f);
        }
        HanaHelper.spawnBlossomEffect(entity);
        this.cooldownComponent.startCooldown(entity, 120.0f);
    }

    private HanaGenericEntity createProjectile(LivingEntity entity) {
        HanaGenericEntity proj = new HanaGenericEntity(entity.field_70170_p, entity, this);
        proj.onEntityImpactEvent = target -> this.clutch(entity, (Entity)target);
        return proj;
    }

    private void clutch(LivingEntity entity, @Nullable Entity targetEntity) {
        if (targetEntity != null && targetEntity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)targetEntity;
            target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 20, 1));
            target.func_195064_c(new EffectInstance((Effect)ModEffects.HANA_HANDS.get(), 20, 0, false, false));
            HanaHandsEntity clutch = new HanaHandsEntity(entity.field_70170_p, this);
            clutch.setWarmup(5);
            clutch.setCaster(entity);
            clutch.setTarget(target);
            clutch.setDamage(10.0f);
            entity.field_70170_p.func_217376_c((Entity)clutch);
            HanaHelper.spawnBlossomEffect(target);
        }
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, MilFleurAbility.Mode mode) {
        if (mode == MilFleurAbility.Mode.NORMAL) {
            this.setDisplayName((ITextComponent)NORMAL_NAME);
            this.setDisplayIcon(NORMAL_ICON);
        } else if (mode == MilFleurAbility.Mode.MIL_FLEUR) {
            this.setDisplayName((ITextComponent)MIL_NAME);
            this.setDisplayIcon(MIL_ICON);
        }
    }

    public void switchNormalMode(LivingEntity entity) {
        this.altModeComponent.setMode(entity, MilFleurAbility.Mode.NORMAL);
    }

    public void switchMilMode(LivingEntity entity) {
        this.altModeComponent.setMode(entity, MilFleurAbility.Mode.MIL_FLEUR);
    }
}

