/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.hiso;

import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.ModMain;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.KungFuDugongEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.YagaraBullEntity;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;

public class AnimalFriendAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "animal_friend", new Pair[]{ImmutablePair.of((Object)"Allows the user to tame all nearby tameable entities, even if they're already tamed by somebody else.", null)});
    private static final TargetsPredicate TARGETS_PREDICATE = new TargetsPredicate().selector(entity -> ModEntityPredicates.canBeTamed().test((Entity)entity));
    private static final int COOLDOWN = 200;
    private static final int RANGE = 10;
    public static final AbilityCore<AnimalFriendAbility> INSTANCE = new AbilityCore.Builder<AnimalFriendAbility>("Animal Friend", AbilityCategory.DEVIL_FRUITS, AnimalFriendAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), RangeComponent.getTooltip(10.0f, RangeComponent.RangeType.AOE)).build();
    private final RangeComponent rangeComponent = new RangeComponent(this);

    public AnimalFriendAbility(AbilityCore<AnimalFriendAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.rangeComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!(entity instanceof PlayerEntity)) {
            ModMain.LOGGER.debug("Ability only usable by Players");
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea((LivingEntity)player, 10.0f, TARGETS_PREDICATE);
        for (LivingEntity target : targets) {
            boolean spawnParticles = false;
            if (target instanceof TameableEntity) {
                ((TameableEntity)target).func_193101_c(player);
                spawnParticles |= true;
            }
            if (target instanceof AbstractHorseEntity) {
                ((AbstractHorseEntity)target).func_110263_g(player);
                spawnParticles |= true;
            }
            if (target instanceof OcelotEntity) {
                Method method = ObfuscationReflectionHelper.findMethod(OcelotEntity.class, (String)"func_213528_r", (Class[])new Class[]{Boolean.TYPE});
                try {
                    method.setAccessible(true);
                    method.invoke((Object)target, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                spawnParticles |= true;
            }
            if (target instanceof KungFuDugongEntity) {
                ((KungFuDugongEntity)target).func_184754_b(player.func_110124_au());
                spawnParticles |= true;
            }
            if (target instanceof YagaraBullEntity) {
                ((YagaraBullEntity)target).func_184754_b(player.func_110124_au());
                spawnParticles |= true;
            }
            if (!spawnParticles) continue;
            this.spawnHearts(player, (Entity)target);
        }
        this.cooldownComponent.startCooldown((LivingEntity)player, 200.0f);
    }

    private void spawnHearts(PlayerEntity player, Entity target) {
        if (player instanceof ServerPlayerEntity) {
            BasicParticleType iparticledata = ParticleTypes.field_197633_z;
            ((ServerWorld)target.field_70170_p).func_195600_a((ServerPlayerEntity)player, (IParticleData)iparticledata, true, target.func_226277_ct_(), target.func_226278_cu_() + 0.75, target.func_226281_cx_(), 7, 0.5, 0.2, 0.5, 0.0);
        }
    }
}

