/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.hiso;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.GameRules;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.init.ModAdvancements;
import xyz.pixelatedw.mineminenomi.mixins.IServerWorldMixin;

public class ForewarnAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "animal_forewarning", new Pair[]{ImmutablePair.of((Object)"Allows the user to communicate with nearby animals and learn when the next rain or clear weathers will come.", null)});
    private static final TargetsPredicate TARGETS_PREDICATE = new TargetsPredicate().selector(AnimalEntity.class::isInstance);
    private static final int COOLDOWN = 200;
    private static final int RANGE = 10;
    public static final AbilityCore<ForewarnAbility> INSTANCE = new AbilityCore.Builder<ForewarnAbility>("Animal Forewarning", AbilityCategory.DEVIL_FRUITS, ForewarnAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), RangeComponent.getTooltip(10.0f, RangeComponent.RangeType.AOE)).build();
    private final RangeComponent rangeComponent = new RangeComponent(this);

    public ForewarnAbility(AbilityCore<ForewarnAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.rangeComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        List<LivingEntity> nearby = this.rangeComponent.getTargetsInArea(entity, 10.0f, TARGETS_PREDICATE);
        if (nearby.size() <= 0) {
            this.cooldownComponent.startCooldown(entity, 200.0f);
            return;
        }
        if (nearby.size() > 0 && !entity.field_70170_p.field_72995_K) {
            boolean weatherStoppedFlag;
            LivingEntity animal = nearby.stream().findFirst().orElse(null);
            if (animal == null) {
                this.cooldownComponent.startCooldown(entity, 200.0f);
                return;
            }
            String moo = "";
            if (animal instanceof CowEntity) {
                if (entity instanceof ServerPlayerEntity) {
                    ModAdvancements.MOOTEOROLOGIST.trigger((ServerPlayerEntity)entity);
                }
                moo = "Moooooo!";
            }
            int rainWeather = ((IServerWorldMixin)entity.field_70170_p).getServerLevelData().func_76083_p();
            int clearWeather = ((IServerWorldMixin)entity.field_70170_p).getServerLevelData().func_230395_g_();
            boolean bl = weatherStoppedFlag = !entity.func_184102_h().func_200252_aR().func_223586_b(GameRules.field_223617_t);
            if (weatherStoppedFlag) {
                entity.func_145747_a((ITextComponent)new StringTextComponent("The weather won't ever change it seems. " + moo), Util.field_240973_b_);
                return;
            }
            if (clearWeather == 0) {
                entity.func_145747_a((ITextComponent)new StringTextComponent("Next rain will happen in " + rainWeather / 1200 + " minutes. " + moo), Util.field_240973_b_);
            } else if (rainWeather == 0) {
                entity.func_145747_a((ITextComponent)new StringTextComponent("Next clear weather will happen in " + clearWeather / 1200 + " minutes. " + moo), Util.field_240973_b_);
            }
        }
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }
}

