/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.hiso;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class LookoutAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "animal_lookout", new Pair[]{ImmutablePair.of((Object)"Allows the user to communicate with nearby animals and learn if other players passed near them.", null)});
    private static final TargetsPredicate TARGETS_PREDICATE = new TargetsPredicate().selector(AnimalEntity.class::isInstance);
    private static final int COOLDOWN = 200;
    private static final int RANGE = 10;
    public static final AbilityCore<LookoutAbility> INSTANCE = new AbilityCore.Builder<LookoutAbility>("Animal Lookout", AbilityCategory.DEVIL_FRUITS, LookoutAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), RangeComponent.getTooltip(10.0f, RangeComponent.RangeType.AOE)).build();
    private final RangeComponent rangeComponent = new RangeComponent(this);

    public LookoutAbility(AbilityCore<LookoutAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.rangeComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 10.0f, TARGETS_PREDICATE);
        for (LivingEntity target : targets) {
            if (target.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() != Items.field_221585_m) continue;
            CompoundNBT tag = target.func_184582_a(EquipmentSlotType.CHEST).func_77978_p();
            ListNBT seen = (ListNBT)tag.func_74781_a("seen");
            entity.func_145747_a((ITextComponent)new StringTextComponent("Recently:"), Util.field_240973_b_);
            seen.forEach(string -> {
                String[] split = string.func_150285_a_().split(" ");
                entity.func_145747_a((ITextComponent)new StringTextComponent(split[0] + " was around here " + (entity.field_70170_p.func_82737_E() - Long.parseLong(split[1])) + " ticks ago"), Util.field_240973_b_);
            });
        }
        if (targets.size() > 0) {
            LivingEntity target = targets.get(0);
            target.func_195064_c(new EffectInstance((Effect)ModEffects.ANIMAL_LOOKOUT.get(), 9999));
            if (entity instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)entity).field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(target.func_145782_y(), target.func_70660_b((Effect)ModEffects.ANIMAL_LOOKOUT.get())));
            }
        }
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }
}

